package com.yutu.base.utils.httpClient;

import com.yutu.base.utils.DateUtil;
import com.yutu.base.utils.MD5;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.CoreConnectionPNames;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.net.CookieStore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class HttpUtil {
	/**
     * 发送get请求
     *
     * @param url
     *            路径
     * @return
     */
    public static String httpGet(String url, String cookie) {
        // get请求返回结果
        String result = null;
        String proxyIp=null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();

            // 发送get请求
            HttpGet request = new HttpGet(url);
            if(cookie!=null&&!"".equals(cookie)){
                request.setHeader("cookie", cookie);
            }
            
            String user="yutu.test";
            String key="bbb75df1fe48720c";
            String timeStamp= "";
            try {
                timeStamp = DateUtil.dateToStamp(DateUtil.DateToStr(new Date(),"yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception e){
                e.printStackTrace();
            }
            String sign= MD5.getMD5Str(key+user+timeStamp);
            request.addHeader(new BasicHeader("user", user));
            request.addHeader(new BasicHeader("timeStamp", timeStamp));
            request.addHeader(new BasicHeader("sign", sign));
            
            HttpResponse response = client.execute(request);

            /** 请求发送成功，并得到响应 **/
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                /** 读取服务器返回过来的字符串 **/
                result = EntityUtils.toString(response.getEntity());
            } else {
                // logger.error("get请求提交失败:" + url);
                System.out.println("{请求FAIL}"+response.getStatusLine().getStatusCode());
                result=Integer.toString(response.getStatusLine().getStatusCode());
            }
        } catch (IOException e) {
            // logger.error("get请求提交失败:" + url, e);
            e.printStackTrace();
            result=e.getMessage();

        }
        return result;
    }
    
    
    /**
     * 发送get请求
     *
     * @param url
     *            路径
     * @return
     */
    public static String httpPost(String url, HttpEntity entity, String cookie, String contentType) {
        // get请求返回结果
        String result = null;
        String proxyIp=null;
        String setCookie=null;
        CookieStore cookiestore=null;
        Map<String,Object> resultMap=new HashMap<String,Object>();
        try {
            DefaultHttpClient client = new DefaultHttpClient();

            client.getParams().setParameter(CoreConnectionPNames.CONNECTION_TIMEOUT, 15000);
            client.getParams().setParameter(CoreConnectionPNames.SO_TIMEOUT, 30000);

            // 发送Post请求
            HttpPost request = new HttpPost(url);
            if(cookie!=null&&!"".equals(cookie)){
                request.setHeader("Cookie", cookie);
            }
            if(contentType!=null&&!"".equals(contentType)){
                request.setHeader("Content-Type", contentType);
            }

            request.setEntity(entity);
            HttpResponse response = client.execute(request);

            /** 请求发送成功，并得到响应 **/
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                /** 读取服务器返回过来的字符串 **/
                result = EntityUtils.toString(response.getEntity());
            } else {
                // logger.error("get请求提交失败:" + url);
                System.out.println("{请求结果FAIL}"+response.getStatusLine().getStatusCode());
                result=Integer.toString(response.getStatusLine().getStatusCode());
            }


        } catch (IOException e) {
            // logger.error("get请求提交失败:" + url, e);
            e.printStackTrace();
            result=e.getMessage();

        }
        return result;

    }
}

