package com.yutu.base.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @description 用于定义将实体对象中的值转换为json时要转换的时间字符串格式,需要在实体类的getTime
 * 方法上打标记:@JsonSerialize(using=JsonDateSerializer.class)
 * 如果实体类用的类型为java.sql.Timestamp则 这里要用java.util.Date类型类转换
 * 不能用java.sql.Date
 * @author aokunsang 
 * @date 2013-5-28 
 */  
public class JsonDateSerializer extends JsonSerializer<Date> {
	@Override
    public void serialize(Date value,
                          JsonGenerator jsonGenerator,
                          SerializerProvider provider)
            throws IOException, JsonProcessingException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        jsonGenerator.writeString(sdf.format(value));  
    }  
}
