package com.yutu.base.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.Scanner;


public class HttpsSendData {
    /**
     * @param url 请求地址
     * @param paramsMap 将参数的名作为键
     * @return
     */
	public static Logger logger= Logger.getLogger(HttpsSendData.class.getName());

    public static String send(String url, Map<String, String> paramsMap) {
        String result = null;
        PostMethod postMethod = null;
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter(
                HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
        postMethod = new PostMethod(url);

        if (paramsMap != null && paramsMap.size() > 0) {
            NameValuePair[] datas = new NameValuePair[paramsMap.size()];
            int index = 0;
            for (String key : paramsMap.keySet()) {
                datas[index++] = new NameValuePair(key,paramsMap.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        HttpClientParams httparams = new HttpClientParams();
        httparams.setSoTimeout(300000);
        postMethod.setParams(httparams);
        try {
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == HttpStatus.SC_OK) {
            	//result = postMethod.getResponseBodyAsString();//原来的方式
            	InputStream is = postMethod.getResponseBodyAsStream();
                Scanner scanner = new Scanner(is, "UTF-8");
                result=scanner.useDelimiter("\\A").next();

            } else {
            	System.out.println("请求状态:"+statusCode);
            }
        } catch (Exception e) {
        	e.printStackTrace();
        }finally {
            if (postMethod != null) {
            	//释放链接
                postMethod.releaseConnection();
            }
            if(url.contains("insert.do") || url.contains("update.do") || url.contains("delete")){
            	logger.info("url:"+url);
            	logger.info("paramsMap:"+paramsMap);
            	logger.info("result:"+ JSONObject.toJSONString(result));
            }
            if(url.contains("notify") || url.contains("assistant")){
            	logger.info("url:"+url);
            	logger.info("paramsMap:"+paramsMap);
            	logger.info("result:"+ JSONObject.toJSONString(result));
            }
            if(url.contains("ia")){
                logger.info("url:"+url);
                logger.info("paramsMap:"+paramsMap);
                logger.info("result:"+ JSONObject.toJSONString(result));
            }
        }
        return result;
    }



	public static String getPost(String url, String body) {

    	//System.out.println("准备开始发送请求:"+System.currentTimeMillis());
        String result = null;
        PostMethod postMethod = new PostMethod(url);
        if(body!=null && !"".equals(body)){
        	StringRequestEntity requestEntity;
			try {
				requestEntity = new StringRequestEntity(body,"application/json","UTF-8");
				postMethod.setRequestEntity(requestEntity);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }

        HttpClientParams httparams = new HttpClientParams();
        httparams.setSoTimeout(180000);
        postMethod.setParams(httparams);
        postMethod.setRequestHeader("Content-Type","application/json;charset=UTF-8");

        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter(
                HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
        try {
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == HttpStatus.SC_OK) {
            	//result = postMethod.getResponseBodyAsString();//原来的方式
            	InputStream is = postMethod.getResponseBodyAsStream();
                Scanner scanner = new Scanner(is, "UTF-8");
                result=scanner.useDelimiter("\\A").next();
            } else {
            	System.out.println("请求状态:   "+statusCode);
            }
        } catch (Exception e) {
        	e.printStackTrace();
        }finally {
            if (postMethod != null) {
            	//释放链接
                postMethod.releaseConnection();
            }
        }
        //System.out.println("收到响应:"+System.currentTimeMillis());
        return result;


	}


	public static String httpPost(String url, String body) {

    	//System.out.println("准备开始发送请求:"+System.currentTimeMillis());
        String result = null;
        PostMethod postMethod = new PostMethod(url);
        if(body!=null && !"".equals(body)){
        	StringRequestEntity requestEntity;
			try {
				requestEntity = new StringRequestEntity(body," application/json ","UTF-8");
				postMethod.setRequestEntity(requestEntity);
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
        }

        HttpClientParams httparams = new HttpClientParams();
        httparams.setSoTimeout(180000);
        postMethod.setParams(httparams);
        postMethod.setRequestHeader("Content-Type", "application/json; charset=UTF-8");

        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter(
                HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
        try {
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == HttpStatus.SC_OK) {
            	//result = postMethod.getResponseBodyAsString();//原来的方式
            	InputStream is = postMethod.getResponseBodyAsStream();
                Scanner scanner = new Scanner(is, "UTF-8");
                result=scanner.useDelimiter("\\A").next();
            } else {
            	System.out.println("请求状态:  "+statusCode);
            }
        } catch (Exception e) {
        	e.printStackTrace();
        }finally {
            if (postMethod != null) {
            	//释放链接
                postMethod.releaseConnection();
            }
        }
        //System.out.println("收到响应:"+System.currentTimeMillis());
        return result;
	}


    /**
     * get 请求
     * @param url
     * @param body
     * @return
     */
    public static String httpGet(String url, String body) {

        //System.out.println("准备开始发送请求:"+System.currentTimeMillis());
        String result = null;
        GetMethod getMethod = new GetMethod(url);
        PostMethod postMethod = new PostMethod(url);
        if(body!=null && !"".equals(body)){
            StringRequestEntity requestEntity;
            try {
                requestEntity = new StringRequestEntity(body,"application/json ","UTF-8");
                postMethod.setRequestEntity(requestEntity);
            } catch (UnsupportedEncodingException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        HttpClientParams httparams = new HttpClientParams();
        httparams.setSoTimeout(180000);
        postMethod.setParams(httparams);
        postMethod.setRequestHeader("Content-Type ","application/json;charset=UTF-8");

        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter(
                HttpMethodParams.HTTP_CONTENT_CHARSET, "utf-8");
        try {
            int statusCode = httpClient.executeMethod(postMethod);
            if (statusCode == HttpStatus.SC_OK) {
                //result = postMethod.getResponseBodyAsString();//原来的方式
                InputStream is = postMethod.getResponseBodyAsStream();
                Scanner scanner = new Scanner(is, "UTF-8");
                result=scanner.useDelimiter("\\A").next();
            } else {
                System.out.println("请求状态: "+statusCode);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }finally {
            if (postMethod != null) {
                //释放链接
                postMethod.releaseConnection();
            }
        }
        //System.out.println("收到响应:"+System.currentTimeMillis());
        return result;
    }



}
