package com.yutu.base.utils;

import org.apache.commons.lang3.time.DateFormatUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * 项目名称：polestarOtaOrder
 * 类名称：DateUtil
 * 类描述：   时间操作类
 * @author wang yu
 * 创建时间：2017-11-01 10:27AM
 * @version
 */
public class DateUtil {

    /**
     * 生成ISO-8601 规范的时间格式
     * @param date
     * @return
     */
    public static String formatISO8601DateString(Date date){
        String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

        return  DateFormatUtils.format(date, pattern);
    }




    /**
     * 获取原时间戳
     * @param reverseTime
     * @return
     */
    public static Long recoverReverseTime(Long reverseTime){
        long longTime = Long.MAX_VALUE - reverseTime;
        return longTime/1000000;
    }

    /*
    * 获取系统当前日期及时间
    * */
    public static Date getCurrentTime(){
        SimpleDateFormat sdf=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date currentTime=null;
        try {
            currentTime= sdf.parse(sdf.format(new Date()));

        } catch (ParseException e) {

            e.printStackTrace();
        }
        return currentTime;
    }

    /**
     * 生成页面普通展示时间
     * @param date
     * @return
     */
    public static String formatNormalDateString(Date date){
        String pattern = "yyyy-MM-dd HH:mm:ss";
        return DateFormatUtils.format(date, pattern);
    }

    /**
     * 日期转换成字符串
     * @param date
     * @return str
     */
    public static String DateToStr(Date date,String formatPattern) {

        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        String str = format.format(date);
        return str;
    }

    /**
     * 字符串转换成日期
     * @param str
     * @return date
     */
    public static Date StrToDate(String str,String formatPattern) {

        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        Date date = null;
        try {
            date = format.parse(str);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    /*
    * 将当前日期增加天数
    * @param date 要计算的日期
    * @param days 要增加的天数
    * @return 计算后的新日期
    * */
    public static Date dayAdd(Date date,int days){
        Calendar ca = Calendar.getInstance();//得到一个Calendar的实例
        ca.setTime(date); //设置时间
        ca.add(Calendar.DAY_OF_MONTH, days); //年份减1
        date = ca.getTime(); //结果
        return date;
    }


    /*
 * 将时间转换为时间戳
 */
    public static String dateToStamp(String s) throws ParseException{
        String res;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = simpleDateFormat.parse(s);
        long ts = date.getTime();
        res = String.valueOf(ts);
        return res;
    }


    /*
 * 将时间戳转换为时间
 */
    public static String stampToDate(String s){
        String res;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lt = new Long(s);
        Date date = new Date(lt);
        res = simpleDateFormat.format(date);
        return res;
    }


}

