package com.yutu.base.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yutu.base.entity.*;
import com.yutu.base.utils.HttpsSendData;
import com.yutu.base.utils.CommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.regex.Pattern;

@Service
public class UploadService {

    private static Logger logger = Logger.getLogger("upload");
    @Value("${spring.urlConfig.productServiceUrl}")
    private String productServiceUrl;

    /**
     * 销售政策上传主方法
     * @param requestBody
     * @return
     */
    public Response uploadSaleRules(String requestBody) {
        if(StringUtils.isBlank(requestBody)){
            return Response.error("参数不能为空！");
        }
        JSONObject reqObj = JSONObject.parseObject(requestBody);
        String filePath = reqObj.getString("filePath");
        String customerId = reqObj.getString("customerId");
        String operator = reqObj.getString("operator");

        List<SaleRules> updateList = new ArrayList<>();//更新的政策
        List<SaleRules> insertList = new ArrayList<>();//新增的政策
        // 创建返回信息对象
        Response response = Response.error("数据异常");
        try {
            //读取一次渠道店铺信息
            Map<String,String> params = new HashMap<>();
            params.put("customerId",customerId);
            String saleStores = HttpsSendData.send(productServiceUrl+"saleStore/findStoreByCustomerId.do",params);
            if(StringUtils.isBlank(saleStores)){
                return Response.error("获取店铺信息失败！");
            }
            JSONObject saleStoreObj = JSONObject.parseObject(saleStores);
            if(saleStoreObj.getInteger("status") != 0){
                return Response.error("获取店铺信息失败！");
            }
            //将查询得到店铺的数据解析成List<SaleStore>
            String storeArrStr = saleStoreObj.getJSONArray("data").toJSONString();
            List<SaleStore> storeList = JSONObject.parseArray(storeArrStr, SaleStore.class);

            long beginTime = System.currentTimeMillis();
            //读取一次现有数据库内已存在数据
            params = new HashMap<>();
            params.put("customerId",customerId);
            String IdResult = HttpsSendData.send(productServiceUrl+"SaleRules/findIdByCustomerId.do",params);
            if(StringUtils.isBlank(IdResult)){
                return Response.error("获取已有全部 政策ID 失败！");
            }
            JSONObject IdResultObj = JSONObject.parseObject(IdResult);
            if(IdResultObj.getInteger("status") != 0){
                return Response.error("获取已有全部 政策ID 失败！");
            }
            //将查询得到的Id数据解析成List<String>
            String IdArrStr = IdResultObj.getJSONArray("data").toJSONString();
            List<String> ids = JSONObject.parseArray(IdArrStr, String.class);
            logger.info("获取数据库全部已有 Id,总用时："+(System.currentTimeMillis()-beginTime)+" ms");

            //List<String> ids = new ArrayList<>();

            @SuppressWarnings("unchecked")
            // 开启工作簿
            Workbook workbook = WorkbookFactory.create(new FileInputStream(filePath));
            // 默认为第一页
            Sheet sheet = workbook.getSheetAt(0);
            // 记录上传信息大小及人员
            logger.info("本次导入数据：" + sheet.getLastRowNum() + "条--" + operator);
            // 开始读取数据
            for (int i = 0; i < sheet.getLastRowNum(); i++) {
                Row row = sheet.getRow(i + 1);
                String channel = getCellString(row.getCell(0));
                if (StringUtils.isBlank(channel)){
                    break;
                }
                if (row != null) {
                    SaleRules rules = getSaleRules(row, i + 1, response, customerId, operator,storeList);
                    if (ids.contains(rules.getId())) {
                        updateList.add(rules);
                    } else {
                        if(rules.getId() == null || rules.getId().length() != 36 )
                            rules.setId(CommonUtil.createId());
                        insertList.add(rules);
                    }
                }
            } // 循环结束
            Timestamp createTime = new Timestamp(System.currentTimeMillis());
            Timestamp updateTime = new Timestamp(System.currentTimeMillis());

            // 执行新增或更新
            logger.info("待插入数据:" + insertList.size() + "条");
            int index = 0 ;
            if (!insertList.isEmpty()) {
                //1.写入政策日志
                for (SaleRules rules : insertList) {
                    ExtraData<SaleRules> extraData = new ExtraData<SaleRules>(rules, "成功");
                    String operatotAtion = operator + "上传新增";
                    SaleLog saleLog = new SaleLog(CommonUtil.createId(), customerId, rules.getId(), "saleRule", operatotAtion,
                            JSONObject.toJSONString(extraData), null, operator, createTime);
                    ScheduleService.setSaleLogQueue(saleLog);//入队列
                    index ++;
                }
                //2.新增数据入库 insertList
                long beginSave = System.currentTimeMillis();
                int num = saveSaleRulesBatch(insertList);
                logger.info("已插入数据:" + num + "条,总用时："+(System.currentTimeMillis()-beginSave) + "ms");
            }
            logger.info("待更新数据:" + updateList.size() + "条");
            index = 0;
            if (!updateList.isEmpty()) {
                //1.写入政策日志
                for (SaleRules rules : updateList) {
                    String Id = rules.getId();
                    params = new HashMap<>();
                    params.put("id",Id);
                    String saleRules = HttpsSendData.send(productServiceUrl+"SaleRules/findById.do",params);
                    JSONObject saleRulesObj = JSONObject.parseObject(saleRules);
                    SaleRules oldRule = JSONObject.parseObject(saleRulesObj.getJSONObject("data").toJSONString(),SaleRules.class);
                    String extraData = new SaleRulesService().getExtraData(oldRule, rules);
                    String operatotAtion = operator + "上传更新";
                    SaleLog saleLog = new SaleLog(CommonUtil.createId(), customerId, rules.getId(), "saleRule", operatotAtion,
                            extraData, null, operator, new Date());
                    ScheduleService.setSaleLogQueue(saleLog);//入队列
                    index ++;
                }
                //2.更新数据入库 updateList
                long beginUpdate = System.currentTimeMillis();
                int num = updateSaleRulesBatch(updateList);
                logger.info("已更新数据：" + num + "条,总用时："+(System.currentTimeMillis()-beginUpdate) + "ms");
            }
        } catch (Exception e) {
            logger.error("UpLoadExcelSaleRulesInsert Failed.[uploadInsert],[NoteResult]:{}"+JSONObject.toJSONString(response),e);
            return response;
        }
        return Response.success("文件上传成功，数据导入成功!");
    }

    //批量新增
    public int saveSaleRulesBatch(List<SaleRules> insertList){
        List<JSONObject> paramsList = handleSaleRuleList(insertList);
        int total = 0;
        if(paramsList.size() > 0){
            for (int i = 0; i < paramsList.size(); i++) {
                String result = HttpsSendData.getPost(
                        productServiceUrl+"SaleRules/saveSaleRulesBatch.do",JSONObject.toJSONString(paramsList.get(i)));
                JSONObject resultObj = JSONObject.parseObject(result);
                if(resultObj.getInteger("status") == 0){
                    logger.info("批量新增成功，数量："+resultObj.getInteger("data"));
                    total += resultObj.getInteger("data");
                }
            }
        }
        return total;
    }

    //批量更新
    public int updateSaleRulesBatch(List<SaleRules> updateList){
        List<JSONObject> paramsList = handleSaleRuleList(updateList);
        int total = 0;
        if(paramsList.size() > 0){
            for (int i = 0; i < paramsList.size(); i++) {
                String result = HttpsSendData.getPost(
                        productServiceUrl+"SaleRules/updateSaleRulesBatch.do",JSONObject.toJSONString(paramsList.get(i)));
                JSONObject resultObj = JSONObject.parseObject(result);
                if(resultObj == null){
                    logger.info("批量更新失败，result：" + result);
                    return 0;
                }
                if(resultObj.getInteger("status") == 0){
                    logger.info("批量更新成功，数量：" + resultObj.getInteger("data"));
                    total += resultObj.getInteger("data");
                }
            }
        }
        return total;
    }
    //批量操作时把数据分批执行
    public List<JSONObject> handleSaleRuleList(List<SaleRules> saleRuleList){
        List<JSONObject> paramsList = new ArrayList<>();
        if(saleRuleList.size() <= 0){

        }
        if(saleRuleList.size() > 0 && saleRuleList.size() <= 500){//大于0 小于等于500一次性批量执行
            JSONArray dataArr = JSONArray.parseArray(JSON.toJSONString(saleRuleList));
            JSONObject params = new JSONObject();
            params.put("data",dataArr);
            paramsList.add(params);
        }
        if(saleRuleList.size() > 500){//大于500 需要分批次执行
            List<SaleRules> tempList = new ArrayList<>();//临时List
            for (int i = 0; i < saleRuleList.size(); i++) {
                tempList.add(saleRuleList.get(i));
                if(tempList.size() >= 500 || i == saleRuleList.size()-1){//满500构造一个List<JSONObject>，最后一个元素装入后执行
                    JSONArray tempArr = JSONArray.parseArray(JSON.toJSONString(tempList));
                    JSONObject params = new JSONObject();
                    params.put("data",tempArr);
                    paramsList.add(params);
                    tempList.clear();//清空临时List
                }
            }
        }
        return paramsList;
    }

    /**
     * 行数据转换为销售规则类
     * @param row 行对象
     * @param rowNum 行数
     * @param customerId 客户id
     * @param operator 操作员
     * @return
     */
    public static SaleRules getSaleRules(Row row, Integer rowNum, Response response, String customerId,
                                         String operator,List<SaleStore> storeList) {
        SaleRules rules = null;
        try {
            String id = getCellString(row.getCell(31));
            String channelId = toConverString(row, 0, rowNum, response);
            String store = toConverString(row, 1, rowNum, response);
            List<String> channelIdArr = Arrays.asList(channelId.split(",",-1));
            List<String> storeArr = Arrays.asList(store.split(",",-1));
            if(!"*".equals(channelId) && !"*".equals(store)){		//渠道不为 *
                if(!"".equals(channelId) && channelId!=null && channelIdArr.size()>0){
                    //1.检查渠道、店铺是否存在
                    for(int j=0;j<channelIdArr.size();j++){	//遍历渠道
                        for(int k=0;k<storeList.size();k++){
                            //渠道是否存在
                            if(channelIdArr.get(j).equals(storeList.get(k).getChannleId())){
                                //检查渠道对应的店铺是否存在
                                if(store.indexOf(storeList.get(k).getStoreCode())==-1){
                                    if("Qunar".endsWith(storeList.get(k).getChannleId())
                                        || "taobao".endsWith(storeList.get(k).getChannleId())){	//Qunar过滤掉

                                    }else{
                                        response.setErrorMessage("渠道对应的店铺缺失,在" + (rowNum + 1) + "行1列! "+channelIdArr.get(j));
                                        throw new RuntimeException("渠道对应的店铺缺失,在" + (rowNum + 1) + "行1列!");
                                    }
                                }
                                break;
                            }else{
                                if(k==storeList.size()-1){
                                    response.setErrorMessage("渠道不存在,在" + (rowNum + 1) + "行1列! "+channelIdArr.get(j));
                                    throw new RuntimeException("渠道不存在,在" + (rowNum + 1) + "行1列!");
                                }
                            }
                        }
                    }
                    for(int j=0;j<storeArr.size();j++){	//遍历店铺
                        for(int k=0;k<storeList.size();k++){
                            //店铺是否存在
                            if(storeArr.get(j).equals(storeList.get(k).getStoreCode())){
                                //检查店铺对应的渠道是否（全部）存在
                                if(channelId.indexOf(storeList.get(k).getChannleId())==-1){
                                    response.setErrorMessage("店铺对应渠道缺失,在" + (rowNum + 1) + "行2列! "+storeArr.get(j));
                                    throw new RuntimeException("店铺对应渠道缺失,在" + (rowNum + 1) + "行2列!");
                                }
                                break;
                            }else{
                                if(k==storeList.size()-1){
                                    response.setErrorMessage("店铺不存在,在" + (rowNum + 1) + "行2列! "+storeArr.get(j));
                                    throw new RuntimeException("店铺不存在,在" + (rowNum + 1) + "行2列!");
                                }
                            }
                        }
                    }
                }
            }else{

            }

            String ruleCode = getCellString(row.getCell(2));
            String carrier = toConverString(row, 3, rowNum, response);
            String org = toConverString(row, 4, rowNum, response);
            String dst = toConverString(row, 5, rowNum, response);
            String applyFlightNum = getCellString(row.getCell(6));
            String notApplicableFlightNum = getCellString(row.getCell(7));
            if (StringUtils.isNotBlank(applyFlightNum)&&StringUtils.isNotBlank(notApplicableFlightNum)){
                response.setErrorMessage("适用航班号和不适用航班号不能同时录入,在" + (rowNum + 1) + "行8列!");
                throw new RuntimeException("适用航班号和不适用航班号不能同时录入,在" + (rowNum + 1) + "行8列!");
            }
            String route = toConverString(row, 8, rowNum, response);
            Integer routeType = null;
            if ("0".equals(route) || "0.0".equals(route)) {
                routeType = 0;
            } else if ("1".equals(route) || "1.0".equals(route)) {
                routeType = 1;
            } else if ("2".equals(route) || "2.0".equals(route)) {
                routeType = 2;
            } else if ("不限".equals(route)) {
                routeType = 0;
            } else if ("单程".equals(route)) {
                routeType = 1;
            } else if ("往返".equals(route)) {
                routeType = 2;
            } else {
                response.setErrorMessage("行程类型错误,在" + (rowNum + 1) + "行9列!");
                throw new RuntimeException("行程类型错误,在" + (rowNum + 1) + "行9列!");
            }
            String policy = toConverString(row, 9, rowNum, response);
            Integer policyType = null;
            if ("普通".equals(policy)) {
                policyType = 1;
            } else if ("积分".equals(policy)) {
                policyType = 2;
            } else if ("普通促销".equals(policy)) {
                policyType = 3;
            } else if ("扣位".equals(policy)) {
                policyType = 4;
            } else if ("促销积分".equals(policy)) {
                policyType = 5;
            } else if ("AG".equals(policy)) {
                policyType = 6;
            } else if ("私有运价".equals(policy)) {
                policyType = 7;
            } else if ("1".equals(policy) || "1.0".equals(policy)) {
                policyType = 1;
            } else if ("2".equals(policy) || "2.0".equals(policy)) {
                policyType = 2;
            } else if ("3".equals(policy) || "3.0".equals(policy)) {
                policyType = 3;
            } else if ("4".equals(policy) || "4.0".equals(policy)) {
                policyType = 4;
            } else if ("5".equals(policy) || "5.0".equals(policy)) {
                policyType = 5;
            } else if ("6".equals(policy) || "6.0".equals(policy)) {
                policyType = 6;
            } else if ("7".equals(policy) || "7.0".equals(policy)) {
                policyType = 7;
            } else {
                response.setErrorMessage("政策类型错误,在" + (rowNum + 1) + "行10列!");
                throw new RuntimeException("政策类型错误,在" + (rowNum + 1) + "行10列!");
            }
            String policyDesc = getCellString(row.getCell(10));
            if (policyDesc == null) {
                policyDesc = "";
            }
            Integer point = toConverInteger(row, 11, rowNum, response);
            Integer costPrice = toConverInteger(row, 12, rowNum, response);
            String saleSdate = toConverString(row, 13, rowNum, response);
            saleSdate = removeZero(saleSdate);
            if(!isValidDate(saleSdate)){
                response.setErrorMessage("日期格式不正确,在" + (rowNum + 1) + "行14列!");
                throw new RuntimeException("日期格式不正确,在" + (rowNum + 1) + "行14列!");
            }
            String saleEdate = toConverString(row, 14, rowNum, response);
            saleEdate = removeZero(saleEdate);
            if(!isValidDate(saleEdate)){
                response.setErrorMessage("日期格式不正确,在" + (rowNum + 1) + "行15列!");
                throw new RuntimeException("日期格式不正确,在" + (rowNum + 1) + "行15列!");
            }
            String ticketDays = getCellString(row.getCell(15));
            if (ticketDays == null) {
                ticketDays = "";
            }
            if(!checkTicketDays(ticketDays)) {
                response.setErrorMessage("提前出票天数不正确,在" + (rowNum + 1) + "行16列!");
                throw new RuntimeException("提前出票天数不正确,在" + (rowNum + 1) + "行16列!");
            }
            String tripSdate = getCellString(row.getCell(16));
            tripSdate = removeZero(tripSdate);
            if(!isValidDate(tripSdate)){
                response.setErrorMessage("日期格式不正确,在" + (rowNum + 1) + "行17列!");
                throw new RuntimeException("日期格式不正确,在" + (rowNum + 1) + "行17列!");
            }
            String tripEdate = getCellString(row.getCell(17));
            tripEdate = removeZero(tripEdate);
            if(!isValidDate(tripEdate)){
                response.setErrorMessage("日期格式不正确,在" + (rowNum + 1) + "行18列!");
                throw new RuntimeException("日期格式不正确,在" + (rowNum + 1) + "行18列!");
            }


            String statusType = toConverString(row, 18, rowNum, response);
            int status = 0;
            if ("启用".equals(statusType)) {
                status = 1;
            } else if ("禁用".equals(statusType)) {
                status = 0;
            } else if ("0".equals(statusType) || "0.0".equals(statusType)) {
                status = 0;
            } else if ("1".equals(statusType) || "1.0".equals(statusType)) {
                status = 1;
            } else {
                response.setErrorMessage("状态信息不正确,在" + (rowNum + 1) + "行19列!");
                throw new RuntimeException();
            }
            Integer minPrice = toConverInteger(row, 19, rowNum, response);
            Integer maxPrice = toConverInteger(row, 20, rowNum, response);
            Integer minProfit = toConverInteger(row, 21, rowNum, response);
            BigDecimal adultPricePoint = new BigDecimal(getCellString(row.getCell(22)));
            Integer adultAddPrice = toConverInteger(row, 23, rowNum, response);
            if (adultAddPrice == null) {
                response.setErrorMessage("在" + (rowNum + 1) + "行24列格式不正确--不能为空");
                throw new RuntimeException("在" + (rowNum + 1) + "行24列格式不正确--不能为空");
            }
            Integer adultAddTax = toConverInteger(row, 24, rowNum, response);
            if (adultAddTax == null) {
                response.setErrorMessage("在" + (rowNum + 1) + "行25列格式不正确--不能为空");
                throw new RuntimeException("在" + (rowNum + 1) + "行25列格式不正确--不能为空");
            }
            BigDecimal adultTaxPoint = new BigDecimal(getCellString(row.getCell(25)));
            BigDecimal childPricePoint = new BigDecimal(getCellString(row.getCell(26)));
            Integer childAddPrice = toConverInteger(row, 27, rowNum, response);
            if (childAddPrice == null) {
                response.setErrorMessage("在" + (rowNum + 1) + "行28列格式不正确--不能为空");
                throw new RuntimeException("在" + (rowNum + 1) + "行28列格式不正确--不能为空");
            }
            Integer childAddTax = toConverInteger(row, 28, rowNum, response);
            if (childAddTax == null) {
                response.setErrorMessage("在" + (rowNum + 1) + "行29列格式不正确--不能为空");
                throw new RuntimeException("在" + (rowNum + 1) + "行29列格式不正确--不能为空");
            }
            BigDecimal childTaxPoint = new BigDecimal(getCellString(row.getCell(29)));
            Timestamp date = new Timestamp(System.currentTimeMillis());
            String cabinCode = getCellString(row.getCell(30));

            //31列为政策Id

            String flightCycle = getCellString(row.getCell(32));
            if(StringUtils.isBlank(flightCycle)){
                flightCycle = null;
            }

            String floorPriceStr = getCellString(row.getCell(33));
            Double floorPrice = null;
            if(StringUtils.isNotBlank(floorPriceStr)){
                floorPrice = Double.parseDouble(floorPriceStr);
            }

            String floorTaxStr = getCellString(row.getCell(34));
            Double floorTax = null;
            if(StringUtils.isNotBlank(floorTaxStr)){
                floorTax = Double.parseDouble(floorTaxStr);
            }

            if(policyType == 7){//若是私有运价   底价票、税、舱位代码不能为空
                if(StringUtils.isBlank(floorPriceStr) || StringUtils.isBlank(floorTaxStr) || StringUtils.isBlank(cabinCode)){
                    response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--私有运价的底价票、税、舱位代码不能为空");
                    throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--私有运价的底价票、税、舱位代码不能为空");
                }
            }

            String fitShareStr = getCellString(row.getCell(35));
            Integer fitShare = 0;
            if("适用".equals(fitShareStr)){
                fitShare = 1;
            }

            String fitNationality = getCellString(row.getCell(36));
            if(StringUtils.isBlank(fitNationality)){
                fitNationality = null;
            }

            String disFitNationality = getCellString(row.getCell(37));
            if(StringUtils.isBlank(disFitNationality)){
                disFitNationality = null;
            }

            String ageRange = getCellString(row.getCell(38));
            if(StringUtils.isBlank(ageRange)){
                ageRange = null;
            }

            String attention = getCellString(row.getCell(39));
            if(StringUtils.isBlank(attention)){
                attention = null;
            }

            rules = new SaleRules(id, customerId, channelId, store, ruleCode, carrier, org, dst, routeType, policyType,
                    policyDesc, point, costPrice, saleSdate, saleEdate, ticketDays, tripSdate, tripEdate, status,
                    maxPrice, minPrice, minProfit, adultPricePoint, adultAddPrice, adultAddTax, adultTaxPoint,
                    childPricePoint, childAddPrice, childAddTax, childTaxPoint, operator, date, date,0,notApplicableFlightNum,applyFlightNum,null,cabinCode,
                    flightCycle,floorPrice,floorTax,fitShare,fitNationality,disFitNationality,ageRange,attention);
        } catch (Exception e) {
            logger.error("UpLoadExcelSaleRulesInsert Failed.[getSaleRules],[Response]:{}"+JSONObject.toJSONString(response),e);
            throw new RuntimeException("createSaleRules:NoteResult:" + response);
        }
        return rules;
    }
    /**
     * 检查ticketDays格式
     * @param ticketDays
     * @return
     */
    public static Boolean checkTicketDays(String ticketDays) {
        final Pattern pattern = Pattern.compile("\\d*\\-\\d*");
        return pattern.matcher(ticketDays).find();
    }
    /**
     * 数据转字符串判定类，进行非空判定
     * @param row 行对象
     * @param cellNum 列数
     * @param rowNum 行数
     * @return 返回获取的数据
     */
    public static String toConverString(Row row, Integer cellNum, Integer rowNum, Response response) {
        String cellString = getCellString(row.getCell(cellNum));
        String value = "";
        try {
            if (cellString == null || "".equals(cellString)) {
                throw new RuntimeException();
            }
            value = cellString;
        } catch (Exception e) {
            logger.info("fail", e);
            response.setErrorMessage("在" + (rowNum + 1) + "行" + (cellNum + 1) + "列格式不正确--不能为空");
            throw new RuntimeException();
        }
        return value;
    }
    /**
     * 去零操作
     * @param string 需要去零的字符串 ，日期操作时使用
     * @return 返回去零结果
     */
    public static String removeZero(String string) {
        String value = "";
        if (string != null && !"".equals(string)) {
            DecimalFormat df = new DecimalFormat("0");
            value = df.format(Double.valueOf(string));
        }
        return value;
    }
    /**
     * 转换为整数型的格式
     * @param row 行元素
     * @param cellNum 列数
     * @param rowNum 行数
     * @return 返回转换后的结果
     */
    public static Integer toConverInteger(Row row, Integer cellNum, Integer rowNum, Response response) {
        String cellString = getCellString(row.getCell(cellNum));
        DecimalFormat df = new DecimalFormat("0");
        Integer value = null;
        try {
            if (cellString == null||"".equals(cellString)) {
                return value;
            }
            value = Integer.valueOf(df.format(Double.valueOf(cellString)));
        } catch (Exception e) {
            response.setErrorMessage("在" + (rowNum + 1) + "行" + (cellNum + 1) + "列格式不正确");
            logger.info("fail", e);
            throw new RuntimeException();
        }
        return value;
    }
    /**
     * 对单元格进行数据获取
     * @param cell 单元格对象
     * @return 统一返回字符串
     */
    protected static String getCellString(Cell cell) {
        String result = null;
        if (cell != null) {
            int cellType = cell.getCellType();
            switch (cellType) {
                case HSSFCell.CELL_TYPE_STRING:
                    result = cell.getStringCellValue();
                    break;
                case HSSFCell.CELL_TYPE_NUMERIC:
                    result = String.valueOf(cell.getNumericCellValue());
                    break;
                case HSSFCell.CELL_TYPE_FORMULA:
                    result = String.valueOf(cell.getNumericCellValue());
                    break;
                case HSSFCell.CELL_TYPE_ERROR:
                    result = null;
                    break;
                case HSSFCell.CELL_TYPE_BOOLEAN:
                    result = String.valueOf(cell.getBooleanCellValue());
                    break;
                case HSSFCell.CELL_TYPE_BLANK:
                    result = null;
                    break;
            }
        }
        return result;
    }

    public static boolean isValidDate(String str) {
        boolean convertSuccess=true;
        if(str.length()!=8){
            convertSuccess=false;
            return convertSuccess;
        }
        // 指定日期格式为四位年/两位月份/两位日期，注意yyyy/MM/dd格式；
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        try {	// 设置lenient为false. 否则SimpleDateFormat会比较宽松地验证日期，比如2007/02/29会被接受，并转换成2007/03/01
            format.setLenient(false);
            format.parse(str);
        } catch (Exception e) {
            e.printStackTrace();// 如果throw java.text.ParseException或者NullPointerException，就说明格式不对
            convertSuccess=false;
        }
        return convertSuccess;
    }

    //上传私有运价底价配置
    public Response uploadPrivateFreight(String requestBody) {
        if (StringUtils.isBlank(requestBody)) {
            return Response.error("requestBody参数不能为空！");
        }
        JSONObject reqObj = JSONObject.parseObject(requestBody);
        String filePath = reqObj.getString("filePath");
        String customerId = reqObj.getString("customerId");
        String operator = reqObj.getString("operator");

        if(StringUtils.isBlank(customerId)){
            return Response.error("customerId参数不能为空！");
        }

        List<PrivateFreight> updateList = new ArrayList<>();//更新的私有运价配置
        List<PrivateFreight> insertList = new ArrayList<>();//新增的私有运价配置
        // 创建返回信息对象
        Response response = Response.error("数据异常");

        try{
            Map<String,String> params = new HashMap<>();
            params.put("customerId",customerId);
            long beginTime = System.currentTimeMillis();
            //读取一次现有数据库内已存在数据
            params = new HashMap<>();
            params.put("customerId",customerId);
            String IdResult = HttpsSendData.send(productServiceUrl+"privateFreight/findIdByCustomerId.do",params);
            if(StringUtils.isBlank(IdResult)){
                return Response.error("获取已有全部 私有运价底价配置ID 失败！");
            }
            JSONObject IdResultObj = JSONObject.parseObject(IdResult);
            if(IdResultObj.getInteger("status") != 0){
                return Response.error("获取已有全部 私有运价底价配置ID 失败！");
            }
            //将查询得到的Id数据解析成List<String>
            String IdArrStr = IdResultObj.getJSONArray("data").toJSONString();
            List<String> ids = JSONObject.parseArray(IdArrStr, String.class);
            logger.info("获取数据库全部已有 私有运价底价配置Id,总用时："+(System.currentTimeMillis()-beginTime)+" ms");

            @SuppressWarnings("unchecked")
            // 开启工作簿
            Workbook workbook = WorkbookFactory.create(new FileInputStream(filePath));
            // 默认为第一页
            Sheet sheet = workbook.getSheetAt(0);
            // 记录上传信息大小及人员
            logger.info("本次导入数据：" + sheet.getLastRowNum() + "条--" + operator);
            // 开始读取数据
            for (int i = 0; i < sheet.getLastRowNum(); i++) {
                Row row = sheet.getRow(i + 1);
                String channel = getCellString(row.getCell(0));
                if (StringUtils.isBlank(channel)){
                    break;
                }
                if (row != null) {
                    PrivateFreight privateFreight = getPrivateFreights(row, i + 1, response, customerId, operator);
                    if (ids.contains(privateFreight.getId())) {
                        updateList.add(privateFreight);
                    } else {
                        if(privateFreight.getId() == null || privateFreight.getId().length() != 36 )
                            privateFreight.setId(CommonUtil.createId());
                        insertList.add(privateFreight);
                    }
                }
            } // 循环结束
            // 执行新增或更新
            logger.info("待插入数据:" + insertList.size() + "条");
            int index = 0 ;
            if (!insertList.isEmpty()) {
                //新增数据入库 insertList
                long beginSave = System.currentTimeMillis();
                int num = savePrivateFreightsBatch(insertList);
                logger.info("已插入数据:" + num + "条,总用时："+(System.currentTimeMillis()-beginSave) + "ms");
            }
            logger.info("待更新数据:" + updateList.size() + "条");
            index = 0;
            if (!updateList.isEmpty()) {
                //更新数据入库 updateList
                long beginUpdate = System.currentTimeMillis();
                int num = updatePrivateFreightsBatch(updateList);
                logger.info("已更新数据：" + num + "条,总用时："+(System.currentTimeMillis()-beginUpdate) + "ms");
            }
            return Response.success("文件上传成功，数据导入成功!");
        }catch (Exception e){
            logger.error("上传失败",e);
        }
        return response;
    }

    public static PrivateFreight getPrivateFreights(Row row, Integer rowNum, Response response, String customerId, String operator) {
        PrivateFreight privateFreight = null;
        try {
            String id = getCellString(row.getCell(9));
            if(StringUtils.isBlank(id)){
                id = UUID.randomUUID().toString();
            }
            String carrier = getCellString(row.getCell(1));
            if(StringUtils.isBlank(carrier)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--航司缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--航司缺失!");
            }
            String org = getCellString(row.getCell(2));
            if(StringUtils.isBlank(org)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--出发地缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--出发地缺失!");
            }
            String dst = getCellString(row.getCell(3));
            if(StringUtils.isBlank(dst)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--抵达地缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--抵达地缺失!");
            }
            String flightNo = getCellString(row.getCell(4));
            if(StringUtils.isBlank(flightNo)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--航班号缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--航班号缺失!");
            }
            String cabin = getCellString(row.getCell(5));
            if(StringUtils.isBlank(cabin)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--舱位代码缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--舱位代码缺失!");
            }
            String floorPriceStr = getCellString(row.getCell(6));
            if(StringUtils.isBlank(floorPriceStr)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--底价票面不能为空!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--底价票面不能为空!");
            }
            String floorTaxStr = getCellString(row.getCell(7));
            if(StringUtils.isBlank(floorTaxStr)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--底价税不能为空!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--底价税不能为空!");
            }
            String ruleCodeIds = getCellString(row.getCell(8));
            if(StringUtils.isBlank(ruleCodeIds)){
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--规则编码缺失!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--规则编码缺失!");
            }
            //对规则Id进行正则判断
            List<String> ruleCodeIdArr = Arrays.asList(ruleCodeIds.split(","));
            boolean isMatch = Boolean.FALSE;
            if(ruleCodeIdArr != null && ruleCodeIdArr.size() > 0){
                for (int i = 0; i < ruleCodeIdArr.size(); i++) {
                    String ruleCode = ruleCodeIdArr.get(i);
                    if(ruleCode.indexOf(",") == -1){
                        if(ruleCode.indexOf("DR-") == 0){
                            isMatch = Pattern.matches("^[A-Z]{2}-(\\d){8}-(\\d){8}$", ruleCode);
                        }else if(ruleCode.indexOf("FW-") == 0){
                            isMatch = Pattern.matches("^[A-Z]{2}-(\\d){1,7}$", ruleCode);
                        }else if(ruleCode.indexOf("FN-") == 0 || ruleCode.indexOf("DN-") == 0){
                            isMatch = Pattern.matches("^[A-Z]{2}-[A-Z]{2}(~[A-Z]{2})*$", ruleCode);
                        }else if(ruleCode.indexOf("AR-") == 0){
                            isMatch = Pattern.matches("^[A-Z]{2}-(\\d){2}-(\\d){2}$", ruleCode);
                        }else if(ruleCode.indexOf("PA-") == 0){
                            isMatch = Pattern.matches("^[A-Z]{2}-.*$", ruleCode);
                        }
                    }
                    if(!isMatch){
                        logger.info("规则编码错误的值是:"+ruleCode);
                        break;
                    }
                }
            }
            if(!isMatch){//匹配失败
                response.setErrorMessage("在" + (rowNum + 1) + "行内容不正确--规则编码格式不正确!");
                throw new RuntimeException("在" + (rowNum + 1) + "行内容不正确--规则编码格式不正确!");
            }

            privateFreight = new PrivateFreight(id, customerId,carrier,org,dst,cabin,flightNo,
                    Double.parseDouble(floorPriceStr),Double.parseDouble(floorTaxStr),ruleCodeIds,
                    operator,new Date(),new Date(),null);
        } catch (Exception e) {
            logger.error("UpLoadExcelPrivateFreightsInsert Failed.[getPrivateFreights],[Response]:{}"+JSONObject.toJSONString(response),e);
            throw new RuntimeException("UpLoadPrivateFreights:NoteResult:" + response);
        }
        return privateFreight;
    }

//    public static void main(String[] args) {
//        boolean isMatch = Pattern.matches("^[A-Z]{2}-(\\d){8}-(\\d){8}$", "DR-20190426-20190430");
//        System.out.println(isMatch);
//    }

    //批量新增
    public int savePrivateFreightsBatch(List<PrivateFreight> insertList){
        int total = 0;
        if(insertList.size() > 0){
            JSONArray insertArr = JSONObject.parseArray(JSONObject.toJSONString(insertList));
            Map<String,String> map = new HashMap<>();
            map.put("reqBody",insertArr.toJSONString());
            String result = HttpsSendData.send(productServiceUrl+"privateFreight/insertBatch.do",map);
            JSONObject resultObj = JSONObject.parseObject(result);
            if(resultObj.getInteger("status") == 0){
                logger.info("批量新增成功，数量："+resultObj.getInteger("data"));
                total += resultObj.getInteger("data");
            }
        }
        return total;
    }

    //批量更新
    public int updatePrivateFreightsBatch(List<PrivateFreight> updateList){
        int total = 0;
        if(updateList.size() > 0){
            JSONArray updateArr = JSONObject.parseArray(JSONObject.toJSONString(updateList));
            Map<String,String> map = new HashMap<>();
            map.put("reqBody",updateArr.toJSONString());
            String result = HttpsSendData.send(productServiceUrl+"privateFreight/updateBatch.do",map);
            JSONObject resultObj = JSONObject.parseObject(result);
            if(resultObj == null){
                logger.info("批量更新失败，result：" + result);
                return 0;
            }
            if(resultObj.getInteger("status") == 0){
                logger.info("批量更新成功，数量：" + resultObj.getInteger("data"));
                total += resultObj.getInteger("data");
            }
        }
        return total;
    }





}

