package com.yutu.base.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yutu.base.entity.SaleLog;
import com.yutu.base.utils.HttpsSendData;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

/**
 * 定时任务业务层
 */
@Component
public class ScheduleService implements CommandLineRunner {

    private static Logger logger = Logger.getLogger("schedule");
    @Value("${spring.urlConfig.polestarLogsServicesUrl}")
    private String polestarLogsServicesUrl;
    @Value("${spring.urlConfig.productServiceUrl}")
    private String productServiceUrl;

    private SimpleDateFormat sdf = null;

    //政策操作日志缓存队列
    public static BlockingQueue<SaleLog> saleLogQueue = new LinkedBlockingQueue<>();

    public static void setSaleLogQueue(SaleLog saleLog) {
        try {
            saleLogQueue.put(saleLog);
        } catch (Exception exception) {
            logger.error("政策操作日志设置失败" + JSONObject.toJSONString(saleLog), exception);
        }
    }

    @Override
    public void run(String... args) throws Exception {
        startScheduleTask();
    }

    /**
     * 政策操作日志通过队列写入MongoDB
     */
    private void startScheduleTask() {
        ExecutorService threadPool = Executors.newFixedThreadPool(1);
        Runnable saveSaleLog = new Runnable() {
            @Override
            public void run() {
                if (saleLogQueue == null) {
                    logger.error("saleLogQueue is null");
                    return;
                }
                List<SaleLog> list = new ArrayList<>();
                SaleLog saleLog = null;
                while (true) {
                    try {
                        list.clear();
                        int num = 0;
                        Long difference = 0L;

                        int size = saleLogQueue.size() > 100 ? 100 : saleLogQueue.size();
                        if (size > 0) {
                            for (int i = 0; i < size; i++) {
                                saleLog = saleLogQueue.take();
                                list.add(saleLog);
                            }
                            if (list.size() > 0) {
                                Long startTime = System.currentTimeMillis();
                                //saveSaleLogsToMongoDBBatch(list);//批量插入
                                saveSaleLogsToMongoDBBatchNew(list);
                                Long endTime = System.currentTimeMillis();
                                difference = endTime - startTime;
                                logger.info("执行新增 SaleLog 数量:" + list.size() + "条! 成功:" + list.size() + "条!"
                                        + " 耗时长:" + String.valueOf(difference) + "ms,剩余" + saleLogQueue.size() + "条日志数据");
                            }
                        } else {
                            Thread.sleep(1000);
                        }
                    } catch (Exception e) {
                        logger.error("销售政策操作日志写入异常-----", e);
                    }
                }
            }
        };
        threadPool.execute(saveSaleLog);
    }

    //MongoDB.logcenter数据库入库(批量插入)
    public void saveSaleLogsToMongoDBBatch(List<SaleLog> saleLogList) {
        JSONArray array = new JSONArray();
        if (saleLogList == null || saleLogList.size() == 0) {
            return;
        }
        for (int i = 0; i < saleLogList.size(); i++) {
            SaleLog saleLog = saleLogList.get(i);
            JSONObject object = new JSONObject();
            object.put("Id", saleLog.getId());
            object.put("customerId", saleLog.getCustomerId());
            object.put("referenceId", saleLog.getReferenceId());
            object.put("logType", saleLog.getLogType());
            object.put("operatorAction", saleLog.getOperatorAction());
            object.put("extraData", saleLog.getExtraData());
            object.put("operatorId", saleLog.getOperatorId());
            object.put("operator", saleLog.getOperator());
            object.put("createTime", saleLog.getCreateTime());
            array.add(object);
        }
        try {
            HttpsSendData.getPost(polestarLogsServicesUrl + "saleLog/saveSaleLogBatch", JSONObject.toJSONString(array));
        } catch (Exception e) {
            logger.error("政策日志写入MongoDB异常", e);
        }
        return;
    }

    //政策日志结构变动，mongodb新数据库需要新字段
    public void saveSaleLogsToMongoDBBatchNew(List<SaleLog> saleLogList) {
        try {
            if (saleLogList == null || saleLogList.size() == 0) {
                return;
            }
            List<String> referenceIdList = new ArrayList<>();
            for (int i = 0; i < saleLogList.size(); i++) {
                referenceIdList.add(saleLogList.get(i).getReferenceId());
            }
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            //通过政策IdList 查询获取政策创建时间  得到 Map<referenceId,ruleCreateTime>
            Map<String, Date> ruleCreateTimeMap = new HashMap<>();
            List<String> ruleCreateTimeList = getRuleCreateTimeListBy(referenceIdList);
            if (ruleCreateTimeList.size() == 0) {
                return;
            }
            for (int i = 0; i < ruleCreateTimeList.size(); i++) {
                String ruleCreateTimeStr = ruleCreateTimeList.get(i);
                String ruleCreateTime = ruleCreateTimeStr.substring(ruleCreateTimeStr.indexOf("^") + 1);
                ruleCreateTimeMap.put(ruleCreateTimeStr.substring(0, ruleCreateTimeStr.indexOf("^")), sdf.parse(ruleCreateTime));
            }
            JSONArray array = JSONArray.parseArray(JSONArray.toJSONString(saleLogList));
            //遍历更新SaleLog
            JSONArray arrayNew = new JSONArray();
            for (int i = 0; i < array.size(); i++) {
                JSONObject saleLog = array.getJSONObject(i);
                String referenceId = saleLog.getString("referenceId");
                saleLog.put("ruleCreateTime", ruleCreateTimeMap.get(referenceId));
                arrayNew.add(saleLog);
            }
            HttpsSendData.getPost(polestarLogsServicesUrl + "saleLog/saveSaleLogBatch", JSONObject.toJSONString(arrayNew));
        } catch (Exception e) {
            logger.error("政策日志写入MongoDB异常", e);
        }
        return;
    }

    //获取政策创建时间
    public List<String> getRuleCreateTimeListBy(List<String> referenceIdList) {
        List<String> resultArr = new ArrayList<>();
        String url = productServiceUrl + "SaleRules/getRuleCreateTimeListBy.do";
        String result = HttpsSendData.getPost(url, JSONArray.toJSONString(referenceIdList));
        if (StringUtils.isBlank(result)) {
            return resultArr;
        }
        resultArr = JSONArray.parseArray(result, String.class);
        return resultArr;
    }


}
