package com.yutu.base.service;

import com.alibaba.fastjson.JSONObject;
import com.yutu.base.utils.HttpsSendData;
import com.yutu.comm.response.NoteResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;

/**
 * 销售汇总
 * @author pc
 * @date 2021年03月24日 18:41
 */
@Service
public class SalesSummaryService {

    @Value("${spring.urlConfig.statementApiUrl}")
    private String statementApiUrl;


    private static Logger logger = Logger.getLogger("saleDetail");



    /**
     * 获取销售汇总报表数据
     *      参数：
     *          startCreateOrderTime endCreateOrderTime 生单时间
     *          startTicketTime endTicketTime 出票时间
     *
     * @param requestBody
     * @return
     */
    public NoteResult getSalesSummaryList(String requestBody) {
        NoteResult noteResult = new NoteResult();
        if (StringUtils.isBlank(requestBody)) {
            noteResult.setStatus(300);
            noteResult.setMsg("参数不能为空 [requestBody] ");
            return noteResult;
        }
        logger.info("开始获取数据，参数： " + requestBody);
        long beginTime = System.currentTimeMillis();

        String result = HttpsSendData.getPost(statementApiUrl + "salesSummary/getSalesSummaryList", requestBody);


        if (StringUtils.isBlank(result)) {
            noteResult.setStatus(300);
            noteResult.setMsg("获取数据失败!");
            noteResult.setData(new HashMap<String, String>());
            return noteResult;
        }
        JSONObject resultObj = JSONObject.parseObject(result);
        if (resultObj.getInteger("status") != 200) {
            noteResult.setMsg("获取数据失败!");
            return noteResult;
        }
        logger.info("获取数据成功，共用时：" + (System.currentTimeMillis() - beginTime));
        return  JSONObject.toJavaObject(resultObj, NoteResult.class);
    }
}
