package com.yutu.base.service;

import com.yutu.base.entity.SaleRules;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

public class SaleRulesService {
    public String getExtraData(SaleRules oldRule, SaleRules newRule) {
        StringBuilder builder = new StringBuilder();
        //状态变化
        if( oldRule!=null ){
            if(oldRule.getStatus() !=null ){
                if (oldRule.getStatus() != newRule.getStatus()) {
                    builder.append("状态变化:[" + getStatusText(oldRule.getStatus()) + "-->"
                            + getStatusText(newRule.getStatus()) + "];");
                }
            }

            if(oldRule.getSaleSdate() !=null ){
                if (!oldRule.getSaleSdate().equals(newRule.getSaleSdate()) ||
                        !oldRule.getSaleEdate().equals(newRule.getSaleEdate())) {
                    builder.append("销售有效期变化:[" + oldRule.getSaleSdate() + "-" + oldRule.getSaleEdate() + "-->" +
                            newRule.getSaleSdate() + "-" + newRule.getSaleEdate() + "];");
                }
            }

            if(oldRule.getTripSdate() !=null){
                if (!oldRule.getTripSdate().equals(newRule.getTripSdate()) ||
                        !oldRule.getTripEdate().equals(newRule.getTripEdate())) {
                    builder.append("旅行有效期变化:[" + oldRule.getTripSdate() + "-" + oldRule.getTripEdate() + "-->" +
                            newRule.getTripSdate() + "-" + newRule.getTripEdate() + "];");
                }
            }

            if(oldRule.getTicketDays() !=null){
                if (!oldRule.getTicketDays().equals(newRule.getTicketDays())) {
                    builder.append("提前购票天数变化:[" + oldRule.getTicketDays() + "-->" +
                            newRule.getTicketDays() + "];");
                }
            }

            if(oldRule.getMinPrice() != null){
                if (!oldRule.getMinPrice().equals(newRule.getMinPrice()) ||
                        !oldRule.getMaxPrice().equals(newRule.getMaxPrice())) {
                    builder.append("价格区间变化:[" + oldRule.getMinPrice() + "-" + oldRule.getMaxPrice() + "-->" +
                            newRule.getMinPrice() + "-" + newRule.getMaxPrice() + "];");
                }
            }

            if(oldRule.getAdultPricePoint() !=null ){
                if ((oldRule.getAdultPricePoint().subtract(newRule.getAdultPricePoint()).compareTo(BigDecimal.ZERO) != 0) ||
                        oldRule.getAdultAddPrice() != newRule.getAdultAddPrice()) {
                    builder.append("成人返点/留钱变化:[" + oldRule.getAdultPricePoint() + "/" + oldRule.getAdultAddPrice() +
                            "-->" + newRule.getAdultPricePoint() + "/" + newRule.getAdultAddPrice() +"];");
                }
            }

            if(oldRule.getChildPricePoint() !=null ){
                if ((oldRule.getChildPricePoint().subtract(newRule.getChildPricePoint()).compareTo(BigDecimal.ZERO) != 0) ||
                        !oldRule.getChildAddPrice().equals(newRule.getChildAddPrice())) {
                    builder.append("儿童返点/留钱变化:[" + oldRule.getChildPricePoint() + "/" + oldRule.getChildAddPrice() +
                            "-->" + newRule.getChildPricePoint() + "/" + newRule.getChildAddPrice() +"];");
                }
            }

            Integer oldMinProfit = oldRule.getMinProfit();
            if (oldMinProfit == null) oldMinProfit = 0;
            if (!oldMinProfit.equals(newRule.getMinProfit())) {
                builder.append("最低利润变化:[" + oldRule.getMinProfit() + "-->" + newRule.getMinProfit() + "]");
            }
            Integer oldPoint = oldRule.getPoint();
            if (oldPoint == null) oldPoint = 0;
            if (!oldPoint.equals(newRule.getPoint())) {
                builder.append("积分值变化:[" + oldPoint + "-->" + newRule.getPoint() + "]");
            }
        }
        if (StringUtils.isBlank(builder.toString())) builder.append("变化内容为空");
        return builder.toString();
    }

    public String getStatusText(Integer status) {
        String oldStatusText = "";
        if (status == 0) {
            oldStatusText = "禁用";
        } else if (status == 1) {
            oldStatusText = "启用";
        } else {
            oldStatusText = "其他";
        }
        return oldStatusText;
    }
}
