package com.yutu.base.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yutu.base.entity.NoteResult;
import com.yutu.base.entity.Response;
import com.yutu.base.utils.HttpsSendData;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 订单相关业务层
 */
@Service
public class PrivateFreightService extends BaseService{

    private Logger logger = Logger.getLogger("privateFreightService");
    @Value("${spring.urlConfig.productServiceUrl}")
    private String productServiceUrl;
    @Value("${spring.pathConfig.saleReportExcelPath}")
    private String  saleReportExcelPath;

    public Response exportPrivateFreight(String requestBody){

        if(StringUtils.isBlank(requestBody)){
            return Response.error("参数不能为空");
        }
        JSONObject reqObj = JSONObject.parseObject(requestBody);
        if(reqObj == null){
            return Response.error("参数有误");
        }
        String customerId = reqObj.getString("customerId");
        if(StringUtils.isBlank(customerId)){
            return Response.error("参数不能为空，必传参数：customerId");
        }

        String carrier = reqObj.getString("carrier");
        String org = reqObj.getString("org");
        String dst = reqObj.getString("dst");
        String startIndex = reqObj.getString("startIndex");
        String count = reqObj.getString("count");
        String flightNo = reqObj.getString("flightNo");
        String cabin = reqObj.getString("cabin");

        JSONObject params = new JSONObject();
        params.put("customerId",customerId);
        params.put("carrier",carrier);
        params.put("org",org);
        params.put("dst",dst);
        params.put("flightNo",flightNo);
        params.put("cabin",cabin);
        params.put("startIndex","1");
        params.put("count","100000");
        NoteResult nr = getPrivateFreights(params);
        if(nr.getStatus() != 0){
            return Response.error("查询数据为空");
        }
        JSONArray privateFreights = (JSONArray) nr.getData();
        String filePath = createPrivateFreightExcel(privateFreights,customerId);
        Response response = Response.success();
        response.setData(filePath);
        response.setErrorMessage("生成订单信息完毕!");
        return response;
    }

    //获取指定条件下全部数据
    public NoteResult getPrivateFreights(JSONObject paramsMap){
        NoteResult noteResult = new NoteResult(2,null,null);
        Map<String,String> map = new HashMap<>();
        map.put("reqBody",paramsMap.toJSONString());
        String result= HttpsSendData.send(productServiceUrl+"privateFreight/findByCondition.do", map);

        JSONObject jsonObject = JSONObject.parseObject(result);
        if(jsonObject!=null && jsonObject.size() > 0){
            noteResult.setStatus(0);
            noteResult.setMsg("获取成功");
            noteResult.setData(jsonObject.getJSONArray("data"));
        }
        return noteResult;
    }

    //解析数据生成Excel表
    public String createPrivateFreightExcel(JSONArray privateFreights,String customerId) {
        String fileBasePath = saleReportExcelPath + customerId + "/PrivateFreightExcel/";;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String date = sdf.format(new Date());
        File file = new File( "私有运价底价配置"+date+".xls");
        System.out.println(file);
        FileOutputStream os = null;
        HSSFWorkbook book = null;
        try{
        //创建工作薄
            book = new HSSFWorkbook();
            HSSFSheet sheet = book.createSheet("私有运价底价配置");
            sheet.setColumnWidth(8, 21 * 456);
            sheet.setColumnWidth(9, 21 * 456);
            // 创建单元格样式
            HSSFCellStyle cellStyleTitle = book.createCellStyle();
            // 指定单元格居中对齐
//            cellStyleTitle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
            // 指定单元格垂直居中对齐
//            cellStyleTitle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
            // 指定当单元格内容显示不下时自动换行
            cellStyleTitle.setWrapText(true);
            // ------------------------------------------------------------------
            HSSFCellStyle cellStyle = book.createCellStyle();
            // 指定单元格居中对齐
//            cellStyle.setAlignment(HSSFCellStyle.ALIGN_CENTER);
            // 指定单元格垂直居中对齐
//            cellStyle.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
            // 指定当单元格内容显示不下时自动换行
            cellStyle.setWrapText(true);
            // ------------------------------------------------------------------
            // 设置单元格字体
            HSSFFont font = book.createFont();
//            font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
            font.setFontName("宋体");
            font.setColor(new Short("255"));
            font.setFontHeight((short) 200);
            cellStyleTitle.setFont(font);
            //创建标题行
            Row title = sheet.createRow(0);
            title.setRowStyle(cellStyleTitle);
            //航司
            Cell carrierTitle = title.createCell(0);
            carrierTitle.setCellStyle(cellStyleTitle);
            carrierTitle.setCellValue("序号");
            //信用余额
            Cell creditTitle = title.createCell(1);
            creditTitle.setCellStyle(cellStyleTitle);
            creditTitle.setCellValue("航司");
            //账户编码
            Cell accountIdTitle = title.createCell(2);
            accountIdTitle.setCellStyle(cellStyleTitle);
            accountIdTitle.setCellValue("出发");
            //账户
            Cell accountTitle = title.createCell(3);
            accountTitle.setCellStyle(cellStyleTitle);
            accountTitle.setCellValue("抵达");
            //账户
            Cell statusTitle = title.createCell(4);
            statusTitle.setCellStyle(cellStyleTitle);
            statusTitle.setCellValue("航班号");
            //密码
            Cell passwordTitle = title.createCell(5);
            passwordTitle.setCellStyle(cellStyleTitle);
            passwordTitle.setCellValue("舱位");
            //邮箱密码
            Cell mailPasswordTitle = title.createCell(6);
            mailPasswordTitle.setCellStyle(cellStyleTitle);
            mailPasswordTitle.setCellValue("底价票面");
            //积分值
            Cell pointTitle = title.createCell(7);
            pointTitle.setCellStyle(cellStyleTitle);
            pointTitle.setCellValue("底价税");
            //可用旅客人数
            Cell usableNumTitle = title.createCell(8);
            usableNumTitle.setCellStyle(cellStyleTitle);
            usableNumTitle.setCellValue("规则编码");
            //id
            Cell idTitle = title.createCell(9);
            idTitle.setCellStyle(cellStyleTitle);
            idTitle.setCellValue("私有运价id");


            //遍历销售规则数据列表
            for (int i = 0; i < privateFreights.size(); i++) {

                Row r = sheet.createRow(i + 1);

                Cell indeixCell = r.createCell(0);
                indeixCell.setCellStyle(cellStyle);
                indeixCell.setCellValue(i + 1);

                Cell usablePassengerNumCell = r.createCell(1);
                usablePassengerNumCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("carrier") != null) {
                    usablePassengerNumCell.setCellValue(privateFreights.getJSONObject(i).getString("carrier"));
                }

                Cell carrierCell = r.createCell(2);
                carrierCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("org") != null) {
                    carrierCell.setCellValue(privateFreights.getJSONObject(i).getString("org"));
                }
                Cell accountIdCell = r.createCell(3);
                accountIdCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("dst") != null) {
                    accountIdCell.setCellValue(privateFreights.getJSONObject(i).getString("dst"));
                }

                Cell statusCell = r.createCell(4);
                statusCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("flightNo") != null) {
                    statusCell.setCellValue(privateFreights.getJSONObject(i).getString("flightNo"));
                }

                Cell accountCell = r.createCell(5);
                accountCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("cabin") != null) {
                    accountCell.setCellValue(privateFreights.getJSONObject(i).getString("cabin"));
                }

                Cell emailPassCell = r.createCell(6);
                emailPassCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("floorPrice") != null) {
                    emailPassCell.setCellValue(privateFreights.getJSONObject(i).getString("floorPrice"));
                }

                Cell pointCell = r.createCell(7);
                pointCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("floorTax") != null) {
                    pointCell.setCellValue(privateFreights.getJSONObject(i).getString("floorTax"));
                }

                Cell flightTimeCell = r.createCell(8);
                flightTimeCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("ruleCodeIds") != null) {
                    flightTimeCell.setCellValue(privateFreights.getJSONObject(i).getString("ruleCodeIds"));
                }

                Cell idCell = r.createCell(9);
                idCell.setCellStyle(cellStyle);
                if (privateFreights.getJSONObject(i).getString("id") != null) {
                    idCell.setCellValue(privateFreights.getJSONObject(i).getString("id"));
                }
            }

            //创建输出流
            os = new FileOutputStream(fileBasePath + file);
            //将book中的数据写出
            book.write(os);
        }catch (Exception e){
            logger.info("生成订单信息Excel异常，异常信息",e);
        }finally {
            try {
                os.close();//关闭流
                book.close();
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return fileBasePath + file;
    }

}
