package com.yutu.base.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yutu.base.entity.Response;
import com.yutu.base.entity.SaleDetail;
import com.yutu.base.entity.Store;
import com.yutu.base.entity.User;
import com.yutu.base.utils.DateUtil;
import io.swagger.models.auth.In;
import jxl.CellView;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.UnderlineStyle;
import jxl.write.*;
import jxl.write.Number;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 将传入的销售报表明细解析成List<SaleDetail>
 */
@Service
@Component
public class ParseToSaleDetail  extends BaseService{
    private Logger logger = Logger.getLogger("download");

    //生成销售明细报表
    public List<SaleDetail> parseToSaleDetailMain(Map<String,String> map,String key){

        List<User> userlist = getUsers();
        List<Store> storelist = getStores();

        logger.info("[自动报表] 开始解析报表对象");
        List<SaleDetail> saleDetailList = new ArrayList<>();

        System.out.println("map:"+ map);

        String orderDetail = map.get("other");
        String purchase = map.get("orderpurchase");
        String transactiondetail = map.get("transactiondetail");
        JSONArray orderArr = JSONArray.parseArray(orderDetail);
        JSONArray purchArr = JSONArray.parseArray(purchase);
        JSONArray transArr = JSONArray.parseArray(transactiondetail);

        try{

            int num = 0;//当前行
            int count_transDetail = 0;
            int count_saleOrder = 0;
            String orderIdStr = "";

            //遍历采购信息
            for(int k=0;k<purchArr.size();k++){

                SaleDetail temp = new SaleDetail();
                temp.setId(UUID.randomUUID().toString());
                temp.setCreateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
//                temp.setUpdateTime(new Date());
                temp.setUpdateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                temp.setKey(key);//标识
                temp.setOfficalReceivedPaymentStatus("");
                temp.setOfficalActualExpendAmount(0.0);
                temp.setOfficalBalance(0.0);
                temp.setOfficalRateAdjustDate(null);


                int mergeNum = 0;//合并行数
                Double profit = 0.0;//利润

                JSONObject purchObj = purchArr.getJSONObject(k);

                Integer deleted = purchObj.getInteger("deleted");
                if(deleted != 0){//已作废、非完整的  的采购信息跳过

                    continue;
                }
                //num值每次更新的时候，就给List<SaleDetail> 更新对象数量
                saleDetailList.add(temp);

                String purchaseId = purchObj.getString("purchaseId");//采购id
                String saleOrderId = purchObj.getString("orderId");//销售id
                if("".equals(saleOrderId) || saleOrderId==null) continue;
                String flightInfoIds = purchObj.getString("flightInfoIds");//航班id
                String passengerIds = purchObj.getString("passengerIds");//乘客id
                int flightSize = flightInfoIds.replace(",","").length()/36;//行程段数
                int passengerSize = passengerIds.replace(",","").length()/36;//乘客人量
                String route = purchObj.getString("routeType");
//                String route = orderArr.get(0).getString("routeType");
                String orderTripType = "";//订单行程类型
                String routeType = convertTripTypeNum(route);//采购行程类型
                String ticketType = convertTripTypeNum(route);//票号类型
//                String points = purchObj.getString("points") != null ? purchObj.getString("points") : "0";//使用积分
                String points = nullToString(purchObj.getString("points"), "0").toString();//使用积分
                String localCurrency = purchObj.getString("localCurrencyCode");//采购币种
                String currency = purchObj.getString("currencyCode");//采购币种
//                String localTotalPrice = purchObj.getString("localTotalPrice") != null ? purchObj.getString("localTotalPrice") : "0";//外币金额
                String localTotalPrice = nullToString(purchObj.getString("localTotalPrice"), "0").toString();//外币金额
                String purchaseTotalPrice = nullToString(purchObj.getString("purchaseTotalPrice"), "0").toString();//本币金额
                String orderValuedAddedOrderNo = purchObj.getString("orderValuedAddedOrderNo");//增值服务单号
                String purchaseChannel = purchObj.getString("purchaseChannel");//采购渠道
                String purchaseAccount = purchObj.getString("purchaseAccount");//采购账户
                String purchaseOrderNo = purchObj.getString("purchaseOrderNo");//采购订单号
                String purchaseOperator = purchObj.getString("purchaseOperator");//出票人
                String purchaseTime = purchObj.getString("purchaseTime");//出票时间
                String remarkText = purchObj.getString("remarkText");//备注信息
                String trueName = "";
                if(userlist!=null && userlist.size()>0){
                    for(int tName=0;tName<userlist.size();tName++){
                        if(userlist.get(tName).getUserID().equals(purchaseOperator)){
                            trueName=userlist.get(tName).getUsername();//出票人真名
                            break;
                        }
                    }
                }
                String orderType = purchObj.getString("orderType");
                orderType = convertOrderType(orderType);
                String owPolicyType = "";//政策类型
                String rtPolicyType = "";//政策类型(返程)
                String owPolicyCode = "";
                String rtPolicyCode = "";
                List<String> policySourceArr = new ArrayList<String>();

                saleDetailList.get(num).setPoints(Integer.parseInt(points));//14        // 注意 判空
                saleDetailList.get(num).setPurchaseCurrency(localCurrency);//15
                saleDetailList.get(num).setOrderValueAddedNo(orderValuedAddedOrderNo);//24
                saleDetailList.get(num).setPurchaseChannel(purchaseChannel);//25
                saleDetailList.get(num).setPurchaseAccount(purchaseAccount);//26
                saleDetailList.get(num).setPurchaseOrderNo(purchaseOrderNo);//27
                saleDetailList.get(num).setOperator(trueName);//31
//                saleDetailList.get(num).setPurchaseTime(purchObj.getDate("purchaseTime"));//32
                saleDetailList.get(num).setPurchaseTime(purchObj.getString("purchaseTime"));//32
                saleDetailList.get(num).setOrderValueAdded(orderType);//33
                saleDetailList.get(num).setRemark(remarkText);//35
                saleDetailList.get(num).setPurchasePrice_local(Double.parseDouble(localTotalPrice));//16    // 注意 判空
                saleDetailList.get(num).setPurchasePrice_rmb(Double.parseDouble(purchaseTotalPrice));//17   // 注意 判空

                //反推销售单信息
                count_saleOrder = 0;
                Double combinOrderTotalPrice = 0.0;
                String ORDERID = "";
                Date createTime = null;//采购时间
                Date ticketTime = null;//出票时间
                String outerOrderNo = "";//外币订单号
                Store store = new Store();//店铺信息
                String flightLine = "";
                String flightTime = "";
                String flightNo = "";
                String productType = "";//附加产品类型
                String productDetail = "";//附加产品规格
                String pnr = "";
                String ticketNumber = "";
                String status = "";
                Double orderValuedPrice = 0.0;

                // 遍历订单
                for(int j=0;j<orderArr.size();j++){
                    JSONObject orderObj = orderArr.getJSONObject(j);
                    String orderId = orderObj.getString("orderId");

//                    if(saleOrderId.indexOf(orderId)>-1){//匹配成功
                    if(saleOrderId.equals(orderId)){//匹配成功
                        ORDERID = orderId;
                        count_saleOrder++;

                        //num值每次更新的时候，就给List<SaleDetail> 更新对象数量
                        if(count_saleOrder > 1){

                            SaleDetail temp1 = new SaleDetail();
                            temp1.setId(UUID.randomUUID().toString());
//                            temp1.setCreateTime(new Date());
//                            temp1.setUpdateTime(new Date());
                            temp1.setCreateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                            temp1.setUpdateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));


                            temp1.setKey(key);//标识
                            temp1.setOfficalReceivedPaymentStatus("");
                            temp1.setOfficalActualExpendAmount(0.0);
                            temp1.setOfficalBalance(0.0);
                            temp1.setOfficalRateAdjustDate(null);

                            saleDetailList.add(temp1);
                        }

                        createTime = orderObj.getDate("createTime");
                        ticketTime = orderObj.getDate("ticketTime");
                        outerOrderNo = orderObj.getString("outerOrderNo");
                        String orderBelong = orderObj.getString("orderBelong");
                        if(storelist!=null && storelist.size()>0){
                            for(int tName=0;tName<storelist.size();tName++){
                                if(storelist.get(tName).getId().equals(orderBelong)){
                                    store = storelist.get(tName);
                                    break;
                                }
                            }
                        }
                        String saleTotlalPrice = orderObj.getString("totalPrice");
                        int orderStatus = orderObj.getInteger("orderStatus");//订单状态
                        String policySource = orderObj.getString("policySource");//政策信息
                        status = convertOrderStatus(orderStatus);

                        saleDetailList.get(num+count_saleOrder-1).setCreateOrderTime(orderObj.getString("createTime"));//0
//                        saleDetailList.get(num+count_saleOrder-1).setTicketTime(orderObj.getDate("ticketTime"));//1
                        saleDetailList.get(num+count_saleOrder-1).setTicketTime(orderObj.getString("ticketTime"));//1
                        saleDetailList.get(num+count_saleOrder-1).setOuterOrderNo(outerOrderNo);//2
                        saleDetailList.get(num+count_saleOrder-1).setChannel(store.getChannelCode());//3
                        saleDetailList.get(num+count_saleOrder-1).setStore(store.getStoreShortName());//4
                        saleDetailList.get(num+count_saleOrder-1).setOrderStatus(status);//30

                        //政策信息
                        if(policySource!=null && !"".equals(policySource)){
                            policySourceArr = Arrays.asList(policySource.split("_",-1));
                        }
                        if(policySourceArr.size()==2){//   去哪儿、同城、航管等   //单程
                            if("0".equals(policySourceArr.get(0)))  owPolicyType = "默认";
                            if("1".equals(policySourceArr.get(0)))  owPolicyType = "普通";
                            if("2".equals(policySourceArr.get(0)))  owPolicyType = "积分";
                            if("3".equals(policySourceArr.get(0)))  owPolicyType = "普通促销";
                            owPolicyCode = policySourceArr.get(1);

                            saleDetailList.get(num+count_saleOrder-2).setPolicyType(owPolicyType);//28
                            saleDetailList.get(num+count_saleOrder-2).setPolicyCode(policySourceArr.get(1));//29
                        }
                        if(policySourceArr.size()==4){//   淘宝-->单程或者往返   其他平台-->往返
                            if("0".equals(policySourceArr.get(0)))  owPolicyType = "默认";
                            if("1".equals(policySourceArr.get(0)))  owPolicyType = "普通";
                            if("2".equals(policySourceArr.get(0)))  owPolicyType = "积分";
                            if("3".equals(policySourceArr.get(0)))  owPolicyType = "普通促销";
                            if("0".equals(policySourceArr.get(2)))  rtPolicyType = "默认";
                            if("1".equals(policySourceArr.get(2)))  rtPolicyType = "普通";
                            if("2".equals(policySourceArr.get(2)))  rtPolicyType = "积分";
                            if("3".equals(policySourceArr.get(2)))  rtPolicyType = "普通促销";
                            if("".equals(policySourceArr.get(2)) && "".equals(policySourceArr.get(3))){
                                saleDetailList.get(num+count_saleOrder-1).setPolicyType(owPolicyType);//28
                                saleDetailList.get(num+count_saleOrder-1).setPolicyCode(policySourceArr.get(1));//29
                            }else{

                                saleDetailList.get(num+count_saleOrder-1).setPolicyType("去程:"+owPolicyType+"\r\n回程:"+rtPolicyType);//28
                                saleDetailList.get(num+count_saleOrder-1).setPolicyCode("去程:"+policySourceArr.get(1)+"\r\n回程:"+policySourceArr.get(3));//29

                                owPolicyCode = "去程:"+owPolicyType+"\r\n回程:"+rtPolicyType;
                                rtPolicyCode = "去程:"+policySourceArr.get(1)+"\r\n回程:"+policySourceArr.get(3);
                            }
                        }
                        if(policySourceArr.size()>=6){//   最新更新后政策信息
                            if("0".equals(policySourceArr.get(1)))  owPolicyType = "默认";
                            if("1".equals(policySourceArr.get(1)))  owPolicyType = "普通";
                            if("2".equals(policySourceArr.get(1)))  owPolicyType = "积分";
                            if("3".equals(policySourceArr.get(1)))  owPolicyType = "普通促销";
                            if("4".equals(policySourceArr.get(1)))  owPolicyType = "官网押位";
                            if("0".equals(policySourceArr.get(4)))  rtPolicyType = "默认";
                            if("1".equals(policySourceArr.get(4)))  rtPolicyType = "普通";
                            if("2".equals(policySourceArr.get(4)))  rtPolicyType = "积分";
                            if("3".equals(policySourceArr.get(4)))  rtPolicyType = "普通促销";
                            if("4".equals(policySourceArr.get(4)))  rtPolicyType = "官网押位";
                            if("".equals(policySourceArr.get(4))){

                                saleDetailList.get(num+count_saleOrder-1).setPolicyType(owPolicyType);//28
                                saleDetailList.get(num+count_saleOrder-1).setPolicyCode(policySourceArr.get(2));//29
                            }else{

                                saleDetailList.get(num+count_saleOrder-1).setPolicyType("去程:"+owPolicyType+"\r\n回程:"+rtPolicyType);//28
                                saleDetailList.get(num+count_saleOrder-1).setPolicyCode("去程:"+policySourceArr.get(2)+"\r\n回程:"+policySourceArr.get(5));//29
                                owPolicyCode = "去程:"+owPolicyType+"\r\n回程:"+rtPolicyType;
                                rtPolicyCode = "去程:"+policySourceArr.get(2)+"\r\n回程:"+policySourceArr.get(5);
                            }
                        }

                        //写入附加产品规格
                        JSONArray ordervalueadded_info=orderObj.getJSONArray("ordervalueadded");//附加产品信息json

                        if(!"".equals(ordervalueadded_info) &&ordervalueadded_info!=null){
                            for(int x=0;x<ordervalueadded_info.size();x++){
                                JSONObject ordervalueadded_data=ordervalueadded_info.getJSONObject(x);
                                productType = ordervalueadded_data.getString("productType");//产品类型
                                String specifications = ordervalueadded_data.getString("specifications");//产品规格
                                String productUnit = ordervalueadded_data.getString("productUnit");//产品单位
                                String quantity = ordervalueadded_data.getString("quantity");//购买数量
                                String price = ordervalueadded_data.getString("price");//购买价格
                                String tripType = ordervalueadded_data.getString("tripType");//行程类型
                                String passengerName = ordervalueadded_data.getString("passengerName");//乘客姓名
                                if("1".equals(productType)){
                                    productType = "行李";
                                }else if("2".equals(productType)){
                                    productType = "值机";
                                }else if("3".equals(productType)){
                                    productType = "餐食";
                                }else if("4".equals(productType)){
                                    productType = "WIFI";
                                }
                                if("0".equals(tripType)){
                                    tripType = "所有";
                                }else if("1".equals(tripType)){
                                    tripType = "单去程";
                                }else if("2".equals(tripType)){
                                    tripType = "单回程";
                                }

                                //2019-03-29注释，原因：订单信息中行李价格为单份总价，并非单价，数量代表一份行李的数量，重量代表一份行李重量
                                //orderValuedPrice += Double.parseDouble(price)*Double.parseDouble(quantity);
                                orderValuedPrice += Double.parseDouble(price);

                                productDetail += ("["+passengerName+"-规格："+specifications+productUnit+";数量："+quantity+";价格:"+price+";行程:"+tripType+"];");
                            }
                        }
                        //销售金额
//                        if(orderIdStr.indexOf(orderId)==-1){
                        if(!orderIdStr.equals(orderId)){
                            orderIdStr += orderId;
                        }else{
                            saleTotlalPrice = "0";
                            orderValuedPrice = 0.0;
                        }

                        saleDetailList.get(num+count_saleOrder-1).setOrderValueAddedSpecific(productDetail);
                        saleDetailList.get(num+count_saleOrder-1).setLuggagePrice(orderValuedPrice);
                        saleDetailList.get(num+count_saleOrder-1).setSalePrice(Double.parseDouble(saleTotlalPrice));

                        combinOrderTotalPrice += Double.parseDouble(saleTotlalPrice);

                        //航班信息
                        JSONArray flightArr = orderObj.getJSONArray("orderflightinfo");
                        flightLine = "";
                        flightTime = "";
                        flightNo = "";
                        if (flightArr.size() != 0){
                            if(flightArr.size()==1)     orderTripType = "单程";
                            if(flightArr.size()==2)     orderTripType = "往返";
                            if(flightArr.size()==3)     orderTripType = "转机";
                        } else {
                            orderTripType = "无";
                        }
                        for(int fli=0;fli<flightArr.size();fli++){
                            JSONObject flightObject = flightArr.getJSONObject(fli);
                            String flightId = flightObject.getString("id");
                            if(flightSize==1){
                                if(flightInfoIds.indexOf(flightId)>-1){
                                    flightLine = flightObject.getString("org")+"-"+flightObject.getString("dst");
                                    flightTime = flightObject.getString("flightTime");
                                    flightNo = flightObject.getString("flightNo");
                                }
                            }else{
                                if(flightInfoIds.indexOf(flightId)>-1){
                                    if(fli != flightArr.size()-1){
                                        flightLine += flightObject.getString("org")+"-"+flightObject.getString("dst")+"\n";
                                        flightNo += flightObject.getString("flightNo")+"\n";
                                    }else {
                                        flightLine += flightObject.getString("org")+"-"+flightObject.getString("dst");
                                        flightNo += flightObject.getString("flightNo");
                                    }
                                    flightTime += flightObject.getString("flightTime");
                                }
                            }
                        }
                        saleDetailList.get(num+count_saleOrder-1).setTairLine(flightLine);//5
                        saleDetailList.get(num+count_saleOrder-1).setFlightTime(flightTime);//6
                        saleDetailList.get(num+count_saleOrder-1).setFlightNumber(flightNo);//7
                        saleDetailList.get(num+count_saleOrder-1).setTripType(orderTripType);//8
                        saleDetailList.get(num+count_saleOrder-1).setPnrType(ticketType);//9

                        //乘客信息
                        String passengerNames = "";
                        Integer adultCount = 0;
                        Integer childCount = 0;

                        JSONArray passengerArr = orderObj.getJSONArray("orderpassenger");
                        for(int pass=0;pass<passengerArr.size();pass++){
                            JSONObject passengerObj = passengerArr.getJSONObject(pass);
                            String passengerId = passengerObj.getString("id");
//                            if(passengerIds.indexOf(passengerId)>-1){
                            if(passengerIds.equals(passengerId)){
                                pnr = passengerObj.getString("pnr");
                                ticketNumber = passengerObj.getString("ticketNumber");
                                passengerNames += passengerObj.getString("passengerName")+",";

                                Integer passengerType = passengerObj.getInteger("passengerType");
                                if(passengerType == 0){
                                    adultCount ++ ;
                                }else {
                                    childCount ++ ;
                                }
                            }
                        }
                        if(pnr.indexOf("/")>-1){
                            if("去程".equals(routeType) || "往返".equals(routeType)){
                                pnr = pnr.substring(0,pnr.indexOf("/"));
                            }else{
                                pnr = pnr.substring(pnr.indexOf("/")+1);
                            }
                        }
                        saleDetailList.get(num+count_saleOrder-1).setPnr(pnr);
                        saleDetailList.get(num+count_saleOrder-1).setPassengerCount(passengerSize);
                        if(StringUtils.isNotBlank(passengerNames)){
                            passengerNames = passengerNames.substring(0,passengerNames.length()-1);
                        }
                        saleDetailList.get(num+count_saleOrder-1).setPassengerNames(passengerNames);
                        saleDetailList.get(num+count_saleOrder-1).setAdultCount(adultCount);
                        saleDetailList.get(num+count_saleOrder-1).setChildCount(childCount);
                    }
                }
                //写入利润
                profit = combinOrderTotalPrice - Double.parseDouble(purchaseTotalPrice) + orderValuedPrice;
                saleDetailList.get(num).setProfit(profit);

                //正推交易流水
                count_transDetail = 0;
                String purchaseId_trans = "";
                String orderId_trans = "";
                String accountId = "";
                String cardNumber = "";
                String transactionNumber = "";
                String localPrice = "";
                String rmbPrice = "";
                if(transArr.size()>0){
                    for(int m=0;m<transArr.size();m++){
                        JSONObject transObj = transArr.getJSONObject(m);
                        String transId = transObj.getString("id");
                        purchaseId_trans = transObj.getString("purchaseId");
                        orderId_trans = transObj.getString("orderId");
                        accountId = transObj.getString("accountId");
                        cardNumber = transObj.getString("cardNumber");
                        transactionNumber = transObj.getString("transactionNumber");
                        localPrice = transObj.getString("localPrice");
                        rmbPrice = transObj.getString("rmbPrice");
                        if(purchaseId.equals(purchaseId_trans)){
                            count_transDetail++;

                            if(count_transDetail > 1){

                                SaleDetail temp2 = new SaleDetail();
                                temp2.setId(UUID.randomUUID().toString());
//                                temp2.setCreateTime(new Date());
//                                temp2.setUpdateTime(new Date());
                                temp2.setCreateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                                temp2.setUpdateTime(DateUtil.DateToStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
                                temp2.setKey(key);//标识
                                temp2.setOfficalReceivedPaymentStatus("");
                                temp2.setOfficalActualExpendAmount(0.0);
                                temp2.setOfficalBalance(0.0);
                                temp2.setOfficalRateAdjustDate(null);

                                saleDetailList.add(temp2);
                                System.out.println(num + count_transDetail - 1);
                            }
                            saleDetailList.get(num+count_transDetail-1).setTransactionDetail_local(Double.parseDouble(localPrice));//18
                            saleDetailList.get(num+count_transDetail-1).setTransactionDetail_rmb(Double.parseDouble(rmbPrice));//19
                            saleDetailList.get(num+count_transDetail-1).setPayMethod(accountId);//20
                            saleDetailList.get(num+count_transDetail-1).setCardNumber(cardNumber);//21
                            saleDetailList.get(num+count_transDetail-1).setTransactionNumber(transactionNumber);//23
                        }else{
                            //以前的报表导出的订单
                            for(int ord = 0;ord<orderArr.size();ord++){
                                JSONObject orderInfo=orderArr.getJSONObject(ord);
                                JSONArray transcationDetail_old = orderInfo.getJSONArray("transactiondetail_old");
                                if(transcationDetail_old!=null && !"".equals(transcationDetail_old)){
                                    for(int tra = 0;tra<transcationDetail_old.size();tra++){
                                        JSONObject traObj = transcationDetail_old.getJSONObject(tra);
                                        orderId_trans = traObj.getString("orderId");
                                        accountId = traObj.getString("accountId");
                                        cardNumber = traObj.getString("cardNumber");
                                        transactionNumber = traObj.getString("transactionNumber");
                                        localPrice = traObj.getString("localPrice");
                                        rmbPrice = traObj.getString("rmbPrice");
                                        if(ORDERID.equals(orderId_trans)){
                                            count_transDetail++;
//                                            sheet.addCell(new Label(20,num+count_transDetail-1,accountId,wcf2));
//                                            sheet.addCell(new Label(21,num+count_transDetail-1,cardNumber,wcf2));
//                                            sheet.addCell(new Label(23,num+count_transDetail-1,transactionNumber,wcf2));
//                                            sheet.addCell(new jxl.write.Number(18,num+count_transDetail-1,Double.parseDouble(localPrice),wcf2));
//                                            sheet.addCell(new jxl.write.Number(19,num+count_transDetail-1,Double.parseDouble(rmbPrice),wcf2));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                else{
                    //以前的报表导出的订单
                    for(int ord = 0;ord<orderArr.size();ord++){
                        JSONObject orderInfo=orderArr.getJSONObject(ord);
                        JSONArray transcationDetail_old = orderInfo.getJSONArray("transactiondetail_old");
                        if(transcationDetail_old!=null && !"".equals(transcationDetail_old)){
                            if(transcationDetail_old.size()>0){
                                for(int tra = 0;tra<transcationDetail_old.size();tra++){
                                    JSONObject traObj = transcationDetail_old.getJSONObject(tra);
                                    orderId_trans = traObj.getString("orderId");
                                    accountId = traObj.getString("accountId");
                                    cardNumber = traObj.getString("cardNumber");
                                    transactionNumber = traObj.getString("transactionNumber");
                                    localPrice = traObj.getString("localPrice");
                                    rmbPrice = traObj.getString("rmbPrice");
                                    if(ORDERID.equals(orderId_trans)){
                                        count_transDetail++;
//                                        sheet.addCell(new Label(20,num+count_transDetail-1,accountId,wcf2));
//                                        sheet.addCell(new Label(21,num+count_transDetail-1,cardNumber,wcf2));
//                                        sheet.addCell(new Label(23,num+count_transDetail-1,transactionNumber,wcf2));
//                                        sheet.addCell(new jxl.write.Number(18,num+count_transDetail-1,Double.parseDouble(localPrice),wcf2));
//                                        sheet.addCell(new Number(19,num+count_transDetail-1,Double.parseDouble(rmbPrice),wcf2));
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
                int D_value = 0;
                D_value = Math.abs(count_saleOrder - count_transDetail);
                mergeNum = count_saleOrder>count_transDetail?count_saleOrder:count_transDetail;

                //销售单对支付信息  一对多，多余的行填充重复的销售单信息
                if(count_saleOrder==1 && count_transDetail>1){
                    for(int repeat = 0;repeat < (count_transDetail-count_saleOrder) ;repeat++){

//                        saleDetailList.get(num + repeat +1).setCreateTime(createTime);
//                        saleDetailList.get(num + repeat +1).setTicketTime(ticketTime);
                        saleDetailList.get(num + repeat +1).setCreateTime(DateUtil.DateToStr(createTime, "yyyy-MM-dd HH:mm:ss"));
                        saleDetailList.get(num + repeat +1).setTicketTime(DateUtil.DateToStr(ticketTime, "yyyy-MM-dd HH:mm:ss"));
                        saleDetailList.get(num + repeat +1).setOuterOrderNo(outerOrderNo);
                        saleDetailList.get(num + repeat +1).setChannel("");
                        saleDetailList.get(num + repeat +1).setStore("");
                        saleDetailList.get(num + repeat +1).setTairLine(flightLine);
                        saleDetailList.get(num + repeat +1).setFlightTime(flightTime);
                        saleDetailList.get(num + repeat +1).setFlightNumber(flightNo);
                        saleDetailList.get(num + repeat +1).setTripType(orderTripType);
                        saleDetailList.get(num + repeat +1).setPnrType(ticketType);
                        saleDetailList.get(num + repeat +1).setPnr(pnr);
                    }
                    //sheet.mergeCells(12,num,12,num+mergeNum-1);//合并订单金额
                }
//                //合并采购信息
//                sheet.mergeCells(11,num,11,num+mergeNum-1);
//                sheet.mergeCells(14,num,14,num+mergeNum-1);
//                sheet.mergeCells(15,num,15,num+mergeNum-1);
//                sheet.mergeCells(16,num,16,num+mergeNum-1);
//                sheet.mergeCells(17,num,17,num+mergeNum-1);
//                sheet.mergeCells(22,num,22,num+mergeNum-1);
//                sheet.mergeCells(24,num,24,num+mergeNum-1);
//                sheet.mergeCells(25,num,25,num+mergeNum-1);
//                sheet.mergeCells(26,num,26,num+mergeNum-1);
//                sheet.mergeCells(27,num,27,num+mergeNum-1);
//                sheet.mergeCells(33,num,33,num+mergeNum-1);
//                sheet.mergeCells(35,num,35,num+mergeNum-1);

                num += mergeNum;
            }
            logger.info("解析销售报表明细成功！");
        }catch (Exception e) {
            e.printStackTrace();
            logger.error("解析销售报表明细异常",e);
        }finally{

        }
        System.out.println(saleDetailList);
        return saleDetailList;
    }

    /**
     * 判空，若为 Null 则替代为给定字符串 "0"
     * @param obj
     * @param toString
     * @return
     */
    public Object nullToString(Object obj, String toString){
        return obj == null ? toString : obj;
    }

    /**
     * 将毫秒数转化为日期格式
     * @param timeMs  传入毫秒数
     * @return
     */
    public String date_s(String timeMs){
//        long time=Long.parseLong(timeMs);
//        Date date=new Date(time);
//        SimpleDateFormat sdf=new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
//        return sdf.format(date).toString();
        return timeMs;
    }
    public String date_alt(String timeMs){
        try{
            long time=Long.parseLong(timeMs);
            Date date=new Date(time);
            SimpleDateFormat sdf=new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            return sdf.format(date);
        }catch (Exception e){

        }
        return timeMs;
    }

    public Date str2Date(String timeMs){
        try{
            long time=Long.parseLong(timeMs);
            Date date=new Date(time);
            return date;
        }catch (Exception e){

        }
        return new Date();
    }

    public String OperName(String userId){
        String TrueName="";
        List<User> list= new ArrayList<>();
        for(int n=0;n<list.size();n++){
            if(list.get(n).getUserID().equals(userId)){
                TrueName=list.get(n).getName();
            }
        }
        return TrueName;
    }
    //订单状态转换
    public String convertOrderStatus(int orderStatus){
        String status = "";
        switch (orderStatus) {
            case 0:status = "未支付";
                break;
            case 2:status = "等待出票";
                break;
            case 3:status = "出票中";
                break;
            case 4:status = "已出票";
                break;
            case 5:status = "出票失败";
                break;
            default:status ="";
                break;
        }
        return status;
    }

    public String convertRouteType(String key){
        switch (key) {
            case "OW":key = "去程";
                break;
            case "RT":key = "回程";
                break;
            case "OWRT":key = "往返";
                break;
            default:key ="";
                break;
        }
        return key;
    }
    public String convertTripType(String key){
        switch (key) {
            case "OW":key = "单程";
                break;
            case "RT":key = "单程";
                break;
            case "OWRT":key = "往返";
                break;
            default:key ="";
                break;
        }
        return key;
    }
    public String convertTripTypeNum(String key){
        switch (key) {
            case "1":key = "单程";
                break;
            case "2":key = "往返";
                break;
            default:key ="";
                break;
        }
        return key;
    }
    public String convertOrderType(String key){
        switch (key) {
            case "ticket":key = "";
                break;
            case "luggage":key = "行李";
                break;
            case "food":key = "餐食";
                break;
            case "checkin":key = "值机";
                break;
            default:key ="";
                break;
        }
        return key;
    }

    /**
     * 快速导出报表（新）
     * @param saleDetails
     * @param filePath
     * @return
     */
    public String createSaleDetailReport(List<SaleDetail> saleDetails, String filePath){
        logger.info("开始生成报表");

        // 写到本地指定文件夹目录中
        File files = new File(filePath);
        if (!files.exists()) {
            files.mkdirs();   // 父目录不存在时创建多级目录
        }
        String file = filePath + new SimpleDateFormat("yyMMddHHmmss").format(new Date())+".xls";

        WritableWorkbook workbook = null;


        try{
            workbook = Workbook.createWorkbook(new File(file));
            DecimalFormat df = new DecimalFormat("######0.00");

            WritableFont wf = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableFont wf_auto = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableCellFormat wcf_integer = new WritableCellFormat(wf_auto,NumberFormats.INTEGER); // 整数
            WritableCellFormat wcf_float = new WritableCellFormat(wf_auto,NumberFormats.FLOAT); // 小数
            wcf_integer.setAlignment(Alignment.CENTRE); // 设置对齐方式
            wcf_float.setAlignment(Alignment.CENTRE); // 设置对齐方式
            WritableCellFormat wcf = new WritableCellFormat(wf); // 单元格定义
            wcf.setAlignment(Alignment.CENTRE); // 设置对齐方式
            WritableCellFormat wcf1 = new WritableCellFormat(wf); // 单元格定义
            wcf1.setAlignment(Alignment.CENTRE); // 设置对齐方式

            WritableCellFormat wcf2 = new WritableCellFormat();
            wcf2.setAlignment(Alignment.CENTRE); // 设置对齐方式
            wcf2.setVerticalAlignment(jxl.format.VerticalAlignment.CENTRE);
            wcf2.setWrap(true);

            WritableSheet sheet = workbook.createSheet("First Sheet", 0);//创建新的一页
            CellView cellView = new CellView();
            cellView.setAutosize(true); //设置自动大小
            cellView.setFormat(wcf1);
            CellView cellView_float = new CellView();
            cellView.setAutosize(true); //设置自动大小
            cellView.setFormat(wcf_float);
            sheet.setColumnView(0,cellView);
            sheet.setColumnView(1,cellView);
            sheet.setColumnView(2,cellView);
            sheet.setColumnView(3,cellView);
            sheet.setColumnView(4,cellView);
            sheet.setColumnView(5,cellView);
            sheet.setColumnView(6,cellView);
            sheet.setColumnView(7,cellView);
            sheet.setColumnView(8,cellView);
            sheet.setColumnView(9,cellView);
            sheet.setColumnView(10,cellView);
            sheet.setColumnView(11,cellView);
            sheet.setColumnView(12,cellView);
            sheet.setColumnView(13,cellView);
            sheet.setColumnView(14,cellView);
            sheet.setColumnView(15,cellView);
            sheet.setColumnView(16,cellView);
            sheet.setColumnView(17,cellView);
            sheet.setColumnView(18,cellView);
            sheet.setColumnView(19,cellView);
            sheet.setColumnView(20,cellView);
            sheet.setColumnView(21,cellView);
            sheet.setColumnView(22,cellView);
            sheet.setColumnView(23,cellView);
            sheet.setColumnView(24,cellView);
            sheet.setColumnView(25,cellView);
            sheet.setColumnView(26,cellView);
            sheet.setColumnView(27,cellView);
            sheet.setColumnView(28,cellView);
            sheet.setColumnView(29,cellView);
            sheet.setColumnView(30,cellView);
            sheet.setColumnView(31,cellView);
            sheet.setColumnView(32,cellView);
            sheet.setColumnView(33,cellView);
            sheet.setColumnView(34,cellView);
            sheet.setColumnView(35,cellView);
            sheet.setColumnView(36,cellView);
            sheet.setColumnView(37,cellView);
            sheet.setColumnView(38,cellView);
            sheet.setColumnView(39,cellView);
            sheet.setColumnView(40,cellView);
            sheet.setColumnView(41,cellView);
            sheet.getSettings().setDefaultColumnWidth(22);//设置默认宽度22px
            sheet.addCell(new Label(0,0,"生单时间",wcf2));
            sheet.addCell(new Label(1,0,"出票时间",wcf2));
            sheet.addCell(new Label(2,0,"订单号",wcf2));
            sheet.addCell(new Label(3,0,"销售渠道",wcf2));
            sheet.addCell(new Label(4,0,"销售店铺",wcf2));
            sheet.addCell(new Label(5,0,"航线",wcf2));
            sheet.addCell(new Label(6,0,"起飞时间",wcf2));
            sheet.addCell(new Label(7,0,"航班号",wcf2));
            sheet.addCell(new Label(8,0,"行程类型",wcf2));
            sheet.addCell(new Label(9,0,"票号类型",wcf2));
            sheet.addCell(new Label(10,0,"编码",wcf2));
            sheet.addCell(new Label(11,0,"人数",wcf2));
            sheet.addCell(new Label(12,0,"成人数量",wcf2));
            sheet.addCell(new Label(13,0,"儿童数量",wcf2));
            sheet.addCell(new Label(14,0,"销售—金额",wcf2));
            sheet.addCell(new Label(15,0,"行李总金额",wcf2));
            sheet.addCell(new Label(16,0,"采购积分",wcf2));
            sheet.addCell(new Label(17,0,"采购币种",wcf2));
            sheet.addCell(new Label(18,0,"采购金额(外)",wcf2));
            sheet.addCell(new Label(19,0,"采购金额(本)",wcf2));
            sheet.addCell(new Label(20,0,"支付明细(外)",wcf2));
            sheet.addCell(new Label(21,0,"支付明细(本)",wcf2));
            sheet.addCell(new Label(22,0,"支付方式",wcf2));
            sheet.addCell(new Label(23,0,"卡号",wcf2));
            sheet.addCell(new Label(24,0,"利润",wcf2));
            sheet.addCell(new Label(25,0,"交易流水号",wcf2));
            sheet.addCell(new Label(26,0,"辅营订单号",wcf2));
            sheet.addCell(new Label(27,0,"采购渠道",wcf2));
            sheet.addCell(new Label(28,0,"采购账户",wcf2));
            sheet.addCell(new Label(29,0,"采购订单号",wcf2));
            sheet.addCell(new Label(30,0,"政策类型",wcf2));
            sheet.addCell(new Label(31,0,"政策编码",wcf2));
            sheet.addCell(new Label(32,0,"订单状态",wcf2));
            sheet.addCell(new Label(33,0,"出票人",wcf2));
            sheet.addCell(new Label(34,0,"采购时间",wcf2));
            sheet.addCell(new Label(35,0,"附加产品",wcf2));
            sheet.addCell(new Label(36,0,"附加产品规格",wcf2));
            sheet.addCell(new Label(37,0,"备注",wcf2));
            sheet.addCell(new Label(38,0,"财务-回款状态",wcf2));
            sheet.addCell(new Label(39,0,"财务-实际支出金额",wcf2));
            sheet.addCell(new Label(40,0,"财务-补差",wcf2));
            sheet.addCell(new Label(41,0,"财务-外币调整日期",wcf2));
            sheet.addCell(new Label(42,0,"航司",wcf2));
            sheet.addCell(new Label(43,0,"旅客姓名",wcf2));
            //遍历采购信息
            if(saleDetails == null || saleDetails.size() == 0){
                logger.info("获取销售明细表数据为空,saleDetails.size()=0");
            }else{
                for (int i = 0; i < saleDetails.size(); i++) {
                    SaleDetail saleDetail = saleDetails.get(i);

                    Integer count = 0;
                    if(i-1 > 0){//如果本票号与上一行票号一致，合并
                        String pnr = saleDetail.getPnr();
                        for (int j = i-1; j >= 0; j--) {
                            if(saleDetails.size() > i+1){
                                if(pnr.equals(saleDetails.get(i+1).getPnr()) && saleDetails.get(i+1).getPurchaseTime() == null){
                                    break;
                                }
                            }
                            if(pnr.equals(saleDetails.get(j).getPnr()) && saleDetail.getPurchaseTime() == null){
                                count ++;
                            }else{
                                break;
                            }
                        }
                    }

                    if(saleDetail.getCreateOrderTime()!=null){
//                        sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetail.getCreateOrderTime().getTime())),wcf2));
                        sheet.addCell(new Label(0,i+1,date_alt(saleDetail.getCreateOrderTime()),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                if(saleDetails.get(i-1).getCreateOrderTime() != null){
                                    saleDetail.setCreateOrderTime(saleDetails.get(i-1).getCreateOrderTime());
                                }
//                                sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetails.get(i-1).getCreateOrderTime().getTime())),wcf2));
                                sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetails.get(i-1).getCreateOrderTime())),wcf2));
                            }
                        }
                    }
                    if(saleDetail.getTicketTime()!=null){
//                        sheet.addCell(new Label(1,i+1,date_alt(String.valueOf(saleDetail.getTicketTime().getTime())),wcf2));
                        sheet.addCell(new Label(1,i+1,date_alt(saleDetail.getTicketTime()),wcf2));
                    }
                    if(saleDetail.getOuterOrderNo()!=null){
                        sheet.addCell(new Label(2,i+1,saleDetail.getOuterOrderNo(),wcf2));
                    }
                    if(StringUtils.isNotBlank(saleDetail.getChannel())){
                        sheet.addCell(new Label(3,i+1,saleDetail.getChannel(),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                sheet.addCell(new Label(3,i+1,saleDetails.get(i-1).getChannel(),wcf2));
                            }
                        }
                    }
                    if(StringUtils.isNotBlank(saleDetail.getStore())){
                        sheet.addCell(new Label(4,i+1,saleDetail.getStore(),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                sheet.addCell(new Label(4,i+1,saleDetails.get(i-1).getStore(),wcf2));
                            }
                        }
                    }
                    if(saleDetail.getTairLine()!=null){
                        sheet.addCell(new Label(5,i+1,saleDetail.getTairLine(),wcf2));
                    }
                    if(saleDetail.getFlightTime()!=null){
                        String flightTime = saleDetail.getFlightTime();
                        if(saleDetail.getFlightTime().length() == 13){
                            flightTime = date_alt(saleDetail.getFlightTime());
                            sheet.addCell(new Label(6,i+1,flightTime,wcf2));
                        }else if(saleDetail.getFlightTime().length() == 26){
                            String flight_from = flightTime.substring(0,13);
                            String flight_ret = flightTime.substring(13);

                            sheet.addCell(new Label(6,i+1,date_alt(flight_from)+"\n"
                                    +date_alt(flight_ret),wcf2));
                        }
                    }
                    if(saleDetail.getFlightNumber()!=null){
                        sheet.addCell(new Label(7,i+1,saleDetail.getFlightNumber(),wcf2));
                    }
                    if(saleDetail.getTripType()!=null){
                        sheet.addCell(new Label(8,i+1,saleDetail.getTripType(),wcf2));
                    }
                    if(saleDetail.getPnrType()!=null){
                        sheet.addCell(new Label(9,i+1,saleDetail.getPnrType(),wcf2));
                    }
                    if(saleDetail.getPnr()!=null){
                        sheet.addCell(new Label(10,i+1,saleDetail.getPnr(),wcf2));
                    }
                    if(saleDetail.getPassengerCount()!=null){
                        sheet.addCell(new Number(11,i+1,saleDetail.getPassengerCount(),wcf2));
                    }

                    if(saleDetail.getAdultCount()!=null){
                        sheet.addCell(new Number(12,i+1,saleDetail.getAdultCount(),wcf2));
                    }
                    if(saleDetail.getChildCount()!=null){
                        sheet.addCell(new Number(13,i+1,saleDetail.getChildCount(),wcf2));
                    }


                    if(saleDetail.getSalePrice()!=null){
                        sheet.addCell(new Number(14,i+1,saleDetail.getSalePrice(),wcf2));
                    }
                    if(saleDetail.getLuggagePrice()!=null){
                        sheet.addCell(new Number(15,i+1,saleDetail.getLuggagePrice(),wcf2));
                    }
                    if(saleDetail.getPoints()!=null){
                        sheet.addCell(new Number(16,i+1,saleDetail.getPoints(),wcf2));
                    }
                    if(saleDetail.getPurchaseCurrency()!=null){
                        sheet.addCell(new Label(17,i+1,saleDetail.getPurchaseCurrency(),wcf2));
                    }
                    if(saleDetail.getPurchasePrice_local()!=null){
                        sheet.addCell(new Number(18,i+1,saleDetail.getPurchasePrice_local(),wcf2));
                    }
                    if(saleDetail.getPurchasePrice_rmb()!=null){
                        sheet.addCell(new Number(19,i+1,saleDetail.getPurchasePrice_rmb(),wcf2));
                    }
                    if(saleDetail.getTransactionDetail_local()!=null){
                        sheet.addCell(new Number(20,i+1,saleDetail.getTransactionDetail_local(),wcf2));
                    }
                    if(saleDetail.getTransactionDetail_rmb()!=null){
                        sheet.addCell(new Number(21,i+1,saleDetail.getTransactionDetail_rmb(),wcf2));
                    }
                    if(saleDetail.getPayMethod()!=null){
                        sheet.addCell(new Label(22,i+1,saleDetail.getPayMethod(),wcf2));
                    }
                    if(saleDetail.getCardNumber()!=null){
                        sheet.addCell(new Label(23,i+1,saleDetail.getCardNumber(),wcf2));
                    }
                    if(saleDetail.getProfit()!=null){
                        sheet.addCell(new Number(24,i+1,saleDetail.getProfit(),wcf2));
                    }
                    if(saleDetail.getTransactionNumber()!=null){
                        sheet.addCell(new Label(25,i+1,saleDetail.getTransactionNumber(),wcf2));
                    }
                    if(saleDetail.getOrderValueAddedNo()!=null){
                        sheet.addCell(new Label(26,i+1,saleDetail.getOrderValueAddedNo(),wcf2));
                    }
                    if(saleDetail.getPurchaseChannel()!=null){
                        sheet.addCell(new Label(27,i+1,saleDetail.getPurchaseChannel(),wcf2));
                    }
                    if(saleDetail.getPurchaseAccount()!=null){
                        sheet.addCell(new Label(28,i+1,saleDetail.getPurchaseAccount(),wcf2));
                    }
                    if(saleDetail.getPurchaseOrderNo()!=null){
                        sheet.addCell(new Label(29,i+1,saleDetail.getPurchaseOrderNo(),wcf2));
                    }
                    if(saleDetail.getPolicyType()!=null){
                        sheet.addCell(new Label(30,i+1,saleDetail.getPolicyType(),wcf2));
                    }
                    if(saleDetail.getPolicyCode()!=null){
                        sheet.addCell(new Label(31,i+1,saleDetail.getPolicyCode(),wcf2));
                    }
                    if(saleDetail.getOrderStatus()!=null){
                        sheet.addCell(new Label(32,i+1,saleDetail.getOrderStatus(),wcf2));
                    }
                    if(saleDetail.getOperator()!=null){
                        sheet.addCell(new Label(33,i+1,saleDetail.getOperator(),wcf2));
                    }
                    if(saleDetail.getPurchaseTime()!=null){
//                        sheet.addCell(new Label(34,i+1,date_alt(String.valueOf(saleDetail.getPurchaseTime().getTime())),wcf2));
                        sheet.addCell(new Label(34,i+1,date_alt(String.valueOf(saleDetail.getPurchaseTime())),wcf2));
                    }
                    if(saleDetail.getOrderValueAdded()!=null){
                        sheet.addCell(new Label(35,i+1,saleDetail.getOrderValueAdded(),wcf2));
                    }
                    if(saleDetail.getOrderValueAddedSpecific()!=null){
                        sheet.addCell(new Label(36,i+1,saleDetail.getOrderValueAddedSpecific(),wcf2));
                    }
                    if(saleDetail.getRemark()!=null){
                        sheet.addCell(new Label(37,i+1,saleDetail.getRemark(),wcf2));
                    }
                    if(saleDetail.getOfficalReceivedPaymentStatus()!=null){
                        sheet.addCell(new Label(38,i+1,saleDetail.getOfficalReceivedPaymentStatus(),wcf2));
                    }
                    sheet.addCell(new Label(39,i+1,"",wcf2));
                    sheet.addCell(new Label(40,i+1,"",wcf2));
                    sheet.addCell(new Label(41,i+1,"",wcf2));

                    String carrier = "";//航司
                    if(StringUtils.isNotBlank(saleDetail.getFlightNumber())){
                        carrier = saleDetail.getFlightNumber().substring(0,2);
                    }
                    sheet.addCell(new Label(42,i+1,carrier,wcf2));

                    if(StringUtils.isNotBlank(saleDetail.getPassengerNames())){
                        sheet.addCell(new Label(43,i+1,saleDetail.getPassengerNames(),wcf2));
                    }

                    if(count > 0){//本采购信息对应票号
                        sheet.mergeCells(10,i+1-count,10,i+1);
                        sheet.mergeCells(11,i+1-count,11,i+1);
                        sheet.mergeCells(16,i+1-count,14,i+1);
                        sheet.mergeCells(17,i+1-count,15,i+1);
                        sheet.mergeCells(18,i+1-count,16,i+1);
                        sheet.mergeCells(19,i+1-count,17,i+1);
                        sheet.mergeCells(24,i+1-count,22,i+1);
                        sheet.mergeCells(26,i+1-count,24,i+1);
                        sheet.mergeCells(27,i+1-count,25,i+1);
                        sheet.mergeCells(28,i+1-count,26,i+1);
                        sheet.mergeCells(29,i+1-count,27,i+1);
                        sheet.mergeCells(33,i+1-count,31,i+1);
                        sheet.mergeCells(34,i+1-count,32,i+1);
                        sheet.mergeCells(43,i+1-count,41,i+1);
                    }
                }
            }
            logger.info("生成销售明细报表成功！");
        }catch (Exception e) {
            e.printStackTrace();
            logger.error("导出Execl异常",e);
        }finally{
            try{
                workbook.write();

                workbook.close();

            }catch (Exception e){
                e.printStackTrace();
                logger.error("写出Execl异常",e);
            }
        }
        return file;
    }

    /**
     * 通过 response 对象向浏览器输出二进制流生成报表
     * @param saleDetails
     * @param response
     * @return
     */
    public String createSaleDetailReport(List<SaleDetail> saleDetails, HttpServletResponse response){
        logger.info("开始生成报表");

        WritableWorkbook workbook = null;

        // 通过响应对象写出

        String file = new SimpleDateFormat("yyMMddHHmmss").format(new Date())+".xls";

        try{
//            workbook = Workbook.createWorkbook(new File(file));
            // 设置response参数，可以打开下载页面
            response.reset();
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String(file.getBytes(), "iso-8859-1"));
            workbook = Workbook.createWorkbook(response.getOutputStream());
            DecimalFormat df = new DecimalFormat("######0.00");

            WritableFont wf = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableFont wf_auto = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
            WritableCellFormat wcf_integer = new WritableCellFormat(wf_auto,NumberFormats.INTEGER); // 整数
            WritableCellFormat wcf_float = new WritableCellFormat(wf_auto,NumberFormats.FLOAT); // 小数
            wcf_integer.setAlignment(Alignment.CENTRE); // 设置对齐方式
            wcf_float.setAlignment(Alignment.CENTRE); // 设置对齐方式
            WritableCellFormat wcf = new WritableCellFormat(wf); // 单元格定义
            wcf.setAlignment(Alignment.CENTRE); // 设置对齐方式
            WritableCellFormat wcf1 = new WritableCellFormat(wf); // 单元格定义
            wcf1.setAlignment(Alignment.CENTRE); // 设置对齐方式

            WritableCellFormat wcf2 = new WritableCellFormat();
            wcf2.setAlignment(Alignment.CENTRE); // 设置对齐方式
            wcf2.setVerticalAlignment(jxl.format.VerticalAlignment.CENTRE);
            wcf2.setWrap(true);

            WritableSheet sheet = workbook.createSheet("First Sheet", 0);//创建新的一页
            CellView cellView = new CellView();
            cellView.setAutosize(true); //设置自动大小
            cellView.setFormat(wcf1);
            CellView cellView_float = new CellView();
            cellView.setAutosize(true); //设置自动大小
            cellView.setFormat(wcf_float);
            sheet.setColumnView(0,cellView);
            sheet.setColumnView(1,cellView);
            sheet.setColumnView(2,cellView);
            sheet.setColumnView(3,cellView);
            sheet.setColumnView(4,cellView);
            sheet.setColumnView(5,cellView);
            sheet.setColumnView(6,cellView);
            sheet.setColumnView(7,cellView);
            sheet.setColumnView(8,cellView);
            sheet.setColumnView(9,cellView);
            sheet.setColumnView(10,cellView);
            sheet.setColumnView(11,cellView);
            sheet.setColumnView(12,cellView);
            sheet.setColumnView(13,cellView);
            sheet.setColumnView(14,cellView);
            sheet.setColumnView(15,cellView);
            sheet.setColumnView(16,cellView);
            sheet.setColumnView(17,cellView);
            sheet.setColumnView(18,cellView);
            sheet.setColumnView(19,cellView);
            sheet.setColumnView(20,cellView);
            sheet.setColumnView(21,cellView);
            sheet.setColumnView(22,cellView);
            sheet.setColumnView(23,cellView);
            sheet.setColumnView(24,cellView);
            sheet.setColumnView(25,cellView);
            sheet.setColumnView(26,cellView);
            sheet.setColumnView(27,cellView);
            sheet.setColumnView(28,cellView);
            sheet.setColumnView(29,cellView);
            sheet.setColumnView(30,cellView);
            sheet.setColumnView(31,cellView);
            sheet.setColumnView(32,cellView);
            sheet.setColumnView(33,cellView);
            sheet.setColumnView(34,cellView);
            sheet.setColumnView(35,cellView);
            sheet.setColumnView(36,cellView);
            sheet.setColumnView(37,cellView);
            sheet.setColumnView(38,cellView);
            sheet.setColumnView(39,cellView);
            sheet.setColumnView(40,cellView);
            sheet.setColumnView(41,cellView);
            sheet.getSettings().setDefaultColumnWidth(22);//设置默认宽度22px
            sheet.addCell(new Label(0,0,"生单时间",wcf2));
            sheet.addCell(new Label(1,0,"出票时间",wcf2));
            sheet.addCell(new Label(2,0,"订单号",wcf2));
            sheet.addCell(new Label(3,0,"销售渠道",wcf2));
            sheet.addCell(new Label(4,0,"销售店铺",wcf2));
            sheet.addCell(new Label(5,0,"航线",wcf2));
            sheet.addCell(new Label(6,0,"起飞时间",wcf2));
            sheet.addCell(new Label(7,0,"航班号",wcf2));
            sheet.addCell(new Label(8,0,"行程类型",wcf2));
            sheet.addCell(new Label(9,0,"票号类型",wcf2));
            sheet.addCell(new Label(10,0,"编码",wcf2));
            sheet.addCell(new Label(11,0,"人数",wcf2));
            sheet.addCell(new Label(12,0,"成人数量",wcf2));
            sheet.addCell(new Label(13,0,"儿童数量",wcf2));
            sheet.addCell(new Label(14,0,"销售—金额",wcf2));
            sheet.addCell(new Label(15,0,"行李总金额",wcf2));
            sheet.addCell(new Label(16,0,"采购积分",wcf2));
            sheet.addCell(new Label(17,0,"采购币种",wcf2));
            sheet.addCell(new Label(18,0,"采购金额(外)",wcf2));
            sheet.addCell(new Label(19,0,"采购金额(本)",wcf2));
            sheet.addCell(new Label(20,0,"支付明细(外)",wcf2));
            sheet.addCell(new Label(21,0,"支付明细(本)",wcf2));
            sheet.addCell(new Label(22,0,"支付方式",wcf2));
            sheet.addCell(new Label(23,0,"卡号",wcf2));
            sheet.addCell(new Label(24,0,"利润",wcf2));
            sheet.addCell(new Label(25,0,"交易流水号",wcf2));
            sheet.addCell(new Label(26,0,"辅营订单号",wcf2));
            sheet.addCell(new Label(27,0,"采购渠道",wcf2));
            sheet.addCell(new Label(28,0,"采购账户",wcf2));
            sheet.addCell(new Label(29,0,"采购订单号",wcf2));
            sheet.addCell(new Label(30,0,"政策类型",wcf2));
            sheet.addCell(new Label(31,0,"政策编码",wcf2));
            sheet.addCell(new Label(32,0,"订单状态",wcf2));
            sheet.addCell(new Label(33,0,"出票人",wcf2));
            sheet.addCell(new Label(34,0,"采购时间",wcf2));
            sheet.addCell(new Label(35,0,"附加产品",wcf2));
            sheet.addCell(new Label(36,0,"附加产品规格",wcf2));
            sheet.addCell(new Label(37,0,"备注",wcf2));
            sheet.addCell(new Label(38,0,"财务-回款状态",wcf2));
            sheet.addCell(new Label(39,0,"财务-实际支出金额",wcf2));
            sheet.addCell(new Label(40,0,"财务-补差",wcf2));
            sheet.addCell(new Label(41,0,"财务-外币调整日期",wcf2));
            sheet.addCell(new Label(42,0,"航司",wcf2));
            sheet.addCell(new Label(43,0,"旅客姓名",wcf2));
            //遍历采购信息
            if(saleDetails == null || saleDetails.size() == 0){
                logger.info("获取销售明细表数据为空,saleDetails.size()=0");
            }else{
                for (int i = 0; i < saleDetails.size(); i++) {
                    SaleDetail saleDetail = saleDetails.get(i);

                    Integer count = 0;
                    if(i-1 > 0){//如果本票号与上一行票号一致，合并
                        String pnr = saleDetail.getPnr();
                        for (int j = i-1; j >= 0; j--) {
                            if(saleDetails.size() > i+1){
                                if(pnr.equals(saleDetails.get(i+1).getPnr()) && saleDetails.get(i+1).getPurchaseTime() == null){
                                    break;
                                }
                            }
                            if(pnr.equals(saleDetails.get(j).getPnr()) && saleDetail.getPurchaseTime() == null){
                                count ++;
                            }else{
                                break;
                            }
                        }
                    }

                    if(saleDetail.getCreateOrderTime()!=null){
//                        sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetail.getCreateOrderTime().getTime())),wcf2));
                        sheet.addCell(new Label(0,i+1,date_alt(saleDetail.getCreateOrderTime()),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                if(saleDetails.get(i-1).getCreateOrderTime() != null){
                                    saleDetail.setCreateOrderTime(saleDetails.get(i-1).getCreateOrderTime());
                                }
//                                sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetails.get(i-1).getCreateOrderTime().getTime())),wcf2));
                                sheet.addCell(new Label(0,i+1,date_alt(String.valueOf(saleDetails.get(i-1).getCreateOrderTime())),wcf2));
                            }
                        }
                    }
                    if(saleDetail.getTicketTime()!=null){
//                        sheet.addCell(new Label(1,i+1,date_alt(String.valueOf(saleDetail.getTicketTime().getTime())),wcf2));
                        sheet.addCell(new Label(1,i+1,date_alt(saleDetail.getTicketTime()),wcf2));
                    }
                    if(saleDetail.getOuterOrderNo()!=null){
                        sheet.addCell(new Label(2,i+1,saleDetail.getOuterOrderNo(),wcf2));
                    }
                    if(StringUtils.isNotBlank(saleDetail.getChannel())){
                        sheet.addCell(new Label(3,i+1,saleDetail.getChannel(),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                sheet.addCell(new Label(3,i+1,saleDetails.get(i-1).getChannel(),wcf2));
                            }
                        }
                    }
                    if(StringUtils.isNotBlank(saleDetail.getStore())){
                        sheet.addCell(new Label(4,i+1,saleDetail.getStore(),wcf2));
                    }else{
                        if(saleDetails.get(i-1) != null){
                            if(saleDetail.getOuterOrderNo().equals(saleDetails.get(i-1).getOuterOrderNo())){
                                sheet.addCell(new Label(4,i+1,saleDetails.get(i-1).getStore(),wcf2));
                            }
                        }
                    }
                    if(saleDetail.getTairLine()!=null){
                        sheet.addCell(new Label(5,i+1,saleDetail.getTairLine(),wcf2));
                    }
                    if(saleDetail.getFlightTime()!=null){
                        String flightTime = saleDetail.getFlightTime();
                        if(saleDetail.getFlightTime().length() == 13){
                            flightTime = date_alt(saleDetail.getFlightTime());
                            sheet.addCell(new Label(6,i+1,flightTime,wcf2));
                        }else if(saleDetail.getFlightTime().length() == 26){
                            String flight_from = flightTime.substring(0,13);
                            String flight_ret = flightTime.substring(13);

                            sheet.addCell(new Label(6,i+1,date_alt(flight_from)+"\n"
                                    +date_alt(flight_ret),wcf2));
                        }
                    }
                    if(saleDetail.getFlightNumber()!=null){
                        sheet.addCell(new Label(7,i+1,saleDetail.getFlightNumber(),wcf2));
                    }
                    if(saleDetail.getTripType()!=null){
                        sheet.addCell(new Label(8,i+1,saleDetail.getTripType(),wcf2));
                    }
                    if(saleDetail.getPnrType()!=null){
                        sheet.addCell(new Label(9,i+1,saleDetail.getPnrType(),wcf2));
                    }
                    if(saleDetail.getPnr()!=null){
                        sheet.addCell(new Label(10,i+1,saleDetail.getPnr(),wcf2));
                    }
                    if(saleDetail.getPassengerCount()!=null){
                        sheet.addCell(new Number(11,i+1,saleDetail.getPassengerCount(),wcf2));
                    }

                    if(saleDetail.getAdultCount()!=null){
                        sheet.addCell(new Number(12,i+1,saleDetail.getAdultCount(),wcf2));
                    }
                    if(saleDetail.getChildCount()!=null){
                        sheet.addCell(new Number(13,i+1,saleDetail.getChildCount(),wcf2));
                    }


                    if(saleDetail.getSalePrice()!=null){
                        sheet.addCell(new Number(14,i+1,saleDetail.getSalePrice(),wcf2));
                    }
                    if(saleDetail.getLuggagePrice()!=null){
                        sheet.addCell(new Number(15,i+1,saleDetail.getLuggagePrice(),wcf2));
                    }
                    if(saleDetail.getPoints()!=null){
                        sheet.addCell(new Number(16,i+1,saleDetail.getPoints(),wcf2));
                    }
                    if(saleDetail.getPurchaseCurrency()!=null){
                        sheet.addCell(new Label(17,i+1,saleDetail.getPurchaseCurrency(),wcf2));
                    }
                    if(saleDetail.getPurchasePrice_local()!=null){
                        sheet.addCell(new Number(18,i+1,saleDetail.getPurchasePrice_local(),wcf2));
                    }
                    if(saleDetail.getPurchasePrice_rmb()!=null){
                        sheet.addCell(new Number(19,i+1,saleDetail.getPurchasePrice_rmb(),wcf2));
                    }
                    if(saleDetail.getTransactionDetail_local()!=null){
                        sheet.addCell(new Number(20,i+1,saleDetail.getTransactionDetail_local(),wcf2));
                    }
                    if(saleDetail.getTransactionDetail_rmb()!=null){
                        sheet.addCell(new Number(21,i+1,saleDetail.getTransactionDetail_rmb(),wcf2));
                    }
                    if(saleDetail.getPayMethod()!=null){
                        sheet.addCell(new Label(22,i+1,saleDetail.getPayMethod(),wcf2));
                    }
                    if(saleDetail.getCardNumber()!=null){
                        sheet.addCell(new Label(23,i+1,saleDetail.getCardNumber(),wcf2));
                    }
                    if(saleDetail.getProfit()!=null){
                        sheet.addCell(new Number(24,i+1,saleDetail.getProfit(),wcf2));
                    }
                    if(saleDetail.getTransactionNumber()!=null){
                        sheet.addCell(new Label(25,i+1,saleDetail.getTransactionNumber(),wcf2));
                    }
                    if(saleDetail.getOrderValueAddedNo()!=null){
                        sheet.addCell(new Label(26,i+1,saleDetail.getOrderValueAddedNo(),wcf2));
                    }
                    if(saleDetail.getPurchaseChannel()!=null){
                        sheet.addCell(new Label(27,i+1,saleDetail.getPurchaseChannel(),wcf2));
                    }
                    if(saleDetail.getPurchaseAccount()!=null){
                        sheet.addCell(new Label(28,i+1,saleDetail.getPurchaseAccount(),wcf2));
                    }
                    if(saleDetail.getPurchaseOrderNo()!=null){
                        sheet.addCell(new Label(29,i+1,saleDetail.getPurchaseOrderNo(),wcf2));
                    }
                    if(saleDetail.getPolicyType()!=null){
                        sheet.addCell(new Label(30,i+1,saleDetail.getPolicyType(),wcf2));
                    }
                    if(saleDetail.getPolicyCode()!=null){
                        sheet.addCell(new Label(31,i+1,saleDetail.getPolicyCode(),wcf2));
                    }
                    if(saleDetail.getOrderStatus()!=null){
                        sheet.addCell(new Label(32,i+1,saleDetail.getOrderStatus(),wcf2));
                    }
                    if(saleDetail.getOperator()!=null){
                        sheet.addCell(new Label(33,i+1,saleDetail.getOperator(),wcf2));
                    }
                    if(saleDetail.getPurchaseTime()!=null){
//                        sheet.addCell(new Label(34,i+1,date_alt(String.valueOf(saleDetail.getPurchaseTime().getTime())),wcf2));
                        sheet.addCell(new Label(34,i+1,date_alt(String.valueOf(saleDetail.getPurchaseTime())),wcf2));
                    }
                    if(saleDetail.getOrderValueAdded()!=null){
                        sheet.addCell(new Label(35,i+1,saleDetail.getOrderValueAdded(),wcf2));
                    }
                    if(saleDetail.getOrderValueAddedSpecific()!=null){
                        sheet.addCell(new Label(36,i+1,saleDetail.getOrderValueAddedSpecific(),wcf2));
                    }
                    if(saleDetail.getRemark()!=null){
                        sheet.addCell(new Label(37,i+1,saleDetail.getRemark(),wcf2));
                    }
                    if(saleDetail.getOfficalReceivedPaymentStatus()!=null){
                        sheet.addCell(new Label(38,i+1,saleDetail.getOfficalReceivedPaymentStatus(),wcf2));
                    }
                    sheet.addCell(new Label(39,i+1,"",wcf2));
                    sheet.addCell(new Label(40,i+1,"",wcf2));
                    sheet.addCell(new Label(41,i+1,"",wcf2));

                    String carrier = "";//航司
                    if(StringUtils.isNotBlank(saleDetail.getFlightNumber())){
                        carrier = saleDetail.getFlightNumber().substring(0,2);
                    }
                    sheet.addCell(new Label(42,i+1,carrier,wcf2));

                    if(StringUtils.isNotBlank(saleDetail.getPassengerNames())){
                        sheet.addCell(new Label(43,i+1,saleDetail.getPassengerNames(),wcf2));
                    }

                    if(count > 0){//本采购信息对应票号
                        sheet.mergeCells(10,i+1-count,10,i+1);
                        sheet.mergeCells(11,i+1-count,11,i+1);
                        sheet.mergeCells(16,i+1-count,14,i+1);
                        sheet.mergeCells(17,i+1-count,15,i+1);
                        sheet.mergeCells(18,i+1-count,16,i+1);
                        sheet.mergeCells(19,i+1-count,17,i+1);
                        sheet.mergeCells(24,i+1-count,22,i+1);
                        sheet.mergeCells(26,i+1-count,24,i+1);
                        sheet.mergeCells(27,i+1-count,25,i+1);
                        sheet.mergeCells(28,i+1-count,26,i+1);
                        sheet.mergeCells(29,i+1-count,27,i+1);
                        sheet.mergeCells(33,i+1-count,31,i+1);
                        sheet.mergeCells(34,i+1-count,32,i+1);
                        sheet.mergeCells(43,i+1-count,41,i+1);
                    }
                }
            }
            logger.info("生成销售明细报表成功！");
        }catch (Exception e) {
            e.printStackTrace();
            logger.error("导出Execl异常",e);
        }finally{
            try{
                workbook.write();

                workbook.close();

            }catch (Exception e){
                e.printStackTrace();
                logger.error("写出Execl异常",e);
            }
        }
        return file;
    }
}
