package com.yutu.base.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yutu.base.entity.Store;
import com.yutu.base.entity.User;
import com.yutu.base.utils.httpClient.HttpUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 基础业务层
 * 当前包含，User、Store等
 */
@Service
public class BaseService {

    @Value("${spring.urlConfig.dataApiUrl}")
    private String dataApiUrl;

    public List<User> getUsers(){
        List<User> userList = new ArrayList<>();
        String result= HttpUtil.httpGet(dataApiUrl+"rest/user/selectAllUsers","");
        if(StringUtils.isNotBlank(result)){
            JSONObject resultObj = JSONObject.parseObject(result);
            if(resultObj.getInteger("status") == 0){
                JSONArray dataArr = resultObj.getJSONArray("data");
                for(int i =0;i<dataArr.size();i++){
                    JSONObject data = dataArr.getJSONObject(i);
                    User user = new User();
                    user.setUserID(data.getString("id"));
                    user.setCustomerID(data.getString("customerId"));
                    user.setName(data.getString("loginName"));
                    user.setUsername(data.getString("userName"));
                    userList.add(user);
                }
            }
        }
        return userList;
    }

    public List<Store> getStores(){
        List<Store> storeList = new ArrayList<>();
        String result= HttpUtil.httpGet(dataApiUrl+"rest/store/selectAllStores","");
        if(StringUtils.isNotBlank(result)){
            JSONObject resultObj = JSONObject.parseObject(result);
            if(resultObj.getInteger("status") == 0){
                JSONArray dataArr = resultObj.getJSONArray("data");
                for(int i =0;i<dataArr.size();i++){
                    JSONObject data = dataArr.getJSONObject(i);
                    Store store = new Store();
                    store.setId(data.getString("id"));
                    store.setCustomerId(data.getString("customerId"));
                    store.setChannelCode(data.getString("channelCode"));
                    store.setStoreName(data.getString("storeName"));
                    store.setStoreShortName(data.getString("storeShortName"));
                    store.setStoreCode(data.getString("storeCode"));
                    store.setStatus(data.getString("status"));
                    store.setDomain(data.getString("domain"));
                    storeList.add(store);
                }
            }
        }
        return storeList;
    }


}
