package com.yutu.base.entity;


import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;


/**
 * 国际机票销售规则实体类
 * @author Administrator
 *
 */
public class SaleRules implements Serializable {
	private static final long serialVersionUID = 1L;
	private String id;//主键id
	private String customerId;//客户id
	private String channelId;//渠道编号 适用的渠道编号  TongCheng,Taobao,Ctrip,Qunar
	private String store; //站点店铺代码
	private String ruleCode; //规则编码
	private String carrier;//航司代码
	private String org;//出发地代码
	private String dst;//抵达地代码
	private Integer routeType;//行程类型 0：不限制 1：单程 2：往返
	private Integer policyType;//政策类型 1：普通 2：积分 3:普通促销 4：扣位 5:积分促销
	private String policyDesc;//政策类型描述
	private Integer point;//积分
	private Integer costPrice;//底价
	private String saleSdate;//销售开始日期
	private String saleEdate;//销售结束日期
	private String ticketDays;//提前出票天数范围
	private String tripSdate;//旅行开始日期
	private String tripEdate;//旅行结束日期
	private Integer status;//状态
	private Integer maxPrice;//匹配的最高价格
	private Integer minPrice;//匹配的最低价
	private Integer minProfit;//最低利润值

	private BigDecimal adultPricePoint;//成人价格加点
	private Integer adultAddPrice;//成人加价


	private BigDecimal childPricePoint;//儿童价格加点
	private Integer childAddPrice;//儿童加价

	private String operator;//操作员名称

	private Date createTime;
	private Date updateTime;
	private Integer deleted;//删除标识，0默认未删除，1已删除
	private String notApplicableFlightNum;//不适用航班号
	private String applyFlightNum;//适用航班号
	private Integer remainCabinNum;//剩余座位数

	private String cabinCode;//舱位代码

	private String flightCycle;//航班周期	可为空或""表示不限制，值=1357表示只适用于周1，3，5，日执飞航班
	private Double floorPrice;//底价票面
	private Double floorTax;//底价税
	private Integer fitShare;//适用共享			默认1，0:不适用，1：适用
	private String fitNationality;//适用国籍		默认空，国家两字代码，多个用逗号隔开
	private String disFitNationality;//不适用国籍 默认空，国家两字代码，多个用逗号隔开
	private String ageRange;//年龄范围	默认空，如30-45，不支持多范围
	private String attention;//购票需知	默认空，自由文本

	public SaleRules(){}

	public SaleRules(String id, String customerId, String channelId, String store, String ruleCode, String carrier, String org, String dst, Integer routeType, Integer policyType, String policyDesc, Integer point, Integer costPrice, String saleSdate, String saleEdate, String ticketDays, String tripSdate, String tripEdate, Integer status, Integer maxPrice, Integer minPrice, Integer minProfit, BigDecimal adultPricePoint, Integer adultAddPrice, Integer adultAddTax, BigDecimal adultTaxPoint, BigDecimal childPricePoint, Integer childAddPrice, Integer childAddTax, BigDecimal childTaxPoint, String operator, Date createTime, Date updateTime, Integer deleted, String notApplicableFlightNum, String applyFlightNum, Integer remainCabinNum, String cabinCode) {
		this.id = id;
		this.customerId = customerId;
		this.channelId = channelId;
		this.store = store;
		this.ruleCode = ruleCode;
		this.carrier = carrier;
		this.org = org;
		this.dst = dst;
		this.routeType = routeType;
		this.policyType = policyType;
		this.policyDesc = policyDesc;
		this.point = point;
		this.costPrice = costPrice;
		this.saleSdate = saleSdate;
		this.saleEdate = saleEdate;
		this.ticketDays = ticketDays;
		this.tripSdate = tripSdate;
		this.tripEdate = tripEdate;
		this.status = status;
		this.maxPrice = maxPrice;
		this.minPrice = minPrice;
		this.minProfit = minProfit;
		this.adultPricePoint = adultPricePoint;
		this.adultAddPrice = adultAddPrice;
		this.childPricePoint = childPricePoint;
		this.childAddPrice = childAddPrice;
		this.operator = operator;
		this.createTime = createTime;
		this.updateTime = updateTime;
		this.deleted = deleted;
		this.notApplicableFlightNum = notApplicableFlightNum;
		this.applyFlightNum = applyFlightNum;
		this.remainCabinNum = remainCabinNum;
		this.cabinCode = cabinCode;
	}

	public SaleRules(String id, String customerId, String channelId, String store, String ruleCode, String carrier, String org, String dst, Integer routeType, Integer policyType, String policyDesc, Integer point, Integer costPrice, String saleSdate, String saleEdate, String ticketDays, String tripSdate, String tripEdate, Integer status, Integer maxPrice, Integer minPrice, Integer minProfit, BigDecimal adultPricePoint, Integer adultAddPrice, Integer adultAddTax, BigDecimal adultTaxPoint, BigDecimal childPricePoint, Integer childAddPrice, Integer childAddTax, BigDecimal childTaxPoint, String operator, Date createTime, Date updateTime, Integer deleted, String notApplicableFlightNum, String applyFlightNum, Integer remainCabinNum, String cabinCode, String flightCycle, Double floorPrice, Double floorTax, Integer fitShare, String fitNationality, String disFitNationality, String ageRange, String attention) {
		this.id = id;
		this.customerId = customerId;
		this.channelId = channelId;
		this.store = store;
		this.ruleCode = ruleCode;
		this.carrier = carrier;
		this.org = org;
		this.dst = dst;
		this.routeType = routeType;
		this.policyType = policyType;
		this.policyDesc = policyDesc;
		this.point = point;
		this.costPrice = costPrice;
		this.saleSdate = saleSdate;
		this.saleEdate = saleEdate;
		this.ticketDays = ticketDays;
		this.tripSdate = tripSdate;
		this.tripEdate = tripEdate;
		this.status = status;
		this.maxPrice = maxPrice;
		this.minPrice = minPrice;
		this.minProfit = minProfit;
		this.adultPricePoint = adultPricePoint;
		this.adultAddPrice = adultAddPrice;
		this.childPricePoint = childPricePoint;
		this.childAddPrice = childAddPrice;
		this.operator = operator;
		this.createTime = createTime;
		this.updateTime = updateTime;
		this.deleted = deleted;
		this.notApplicableFlightNum = notApplicableFlightNum;
		this.applyFlightNum = applyFlightNum;
		this.remainCabinNum = remainCabinNum;
		this.cabinCode = cabinCode;
		this.flightCycle = flightCycle;
		this.floorPrice = floorPrice;
		this.floorTax = floorTax;
		this.fitShare = fitShare;
		this.fitNationality = fitNationality;
		this.disFitNationality = disFitNationality;
		this.ageRange = ageRange;
		this.attention = attention;
	}

	public String getCabinCode() {
		return cabinCode;
	}

	public void setCabinCode(String cabinCode) {
		this.cabinCode = cabinCode;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCustomerId() {
		return customerId;
	}

	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getChannelId() {
		return channelId;
	}

	public void setChannelId(String channelId) {
		this.channelId = channelId;
	}

	public String getStore() {
		return store;
	}

	public void setStore(String store) {
		this.store = store;
	}

	public String getCarrier() {
		return carrier;
	}

	public void setCarrier(String carrier) {
		this.carrier = carrier;
	}

	public String getOrg() {
		return org;
	}

	public void setOrg(String org) {
		this.org = org;
	}

	public String getDst() {
		return dst;
	}

	public void setDst(String dst) {
		this.dst = dst;
	}

	/**
	 * 政策类型 1：普通 2：积分 3:普通促销 4：扣位 5:积分促销
	 * @return
	 */
	public Integer getPolicyType() {
		return policyType;
	}

	public void setPolicyType(Integer policyType) {
		this.policyType = policyType;
	}

	public String getPolicyDesc() {
		return policyDesc;
	}

	public void setPolicyDesc(String policyDesc) {
		this.policyDesc = policyDesc;
	}
	public String getSaleSdate() {
		return saleSdate;
	}

	public void setSaleSdate(String saleSdate) {
		this.saleSdate = saleSdate;
	}
	public String getSaleEdate() {
		return saleEdate;
	}

	public void setSaleEdate(String saleEdate) {
		this.saleEdate = saleEdate;
	}

	public String getTicketDays() {
		return ticketDays;
	}

	public void setTicketDays(String ticketDays) {
		this.ticketDays = ticketDays;
	}
	public String getTripSdate() {
		return tripSdate;
	}

	public void setTripSdate(String tripSdate) {
		this.tripSdate = tripSdate;
	}
	public String getTripEdate() {
		return tripEdate;
	}

	public void setTripEdate(String tripEdate) {
		this.tripEdate = tripEdate;
	}

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public Integer getMaxPrice() {
		return maxPrice;
	}

	public void setMaxPrice(Integer maxPrice) {
		this.maxPrice = maxPrice;
	}

	public Integer getMinPrice() {
		return minPrice;
	}

	public void setMinPrice(Integer minPrice) {
		this.minPrice = minPrice;
	}

	public Integer getMinProfit() {
		return minProfit;
	}

	public void setMinProfit(Integer minProfit) {
		this.minProfit = minProfit;
	}

	public BigDecimal getAdultPricePoint() {
		return adultPricePoint;
	}

	public void setAdultPricePoint(BigDecimal adultPricePoint) {
		this.adultPricePoint = adultPricePoint;
	}

	public Integer getAdultAddPrice() {
		return adultAddPrice;
	}

	public void setAdultAddPrice(Integer adultAddPrice) {
		this.adultAddPrice = adultAddPrice;
	}

	public BigDecimal getChildPricePoint() {
		return childPricePoint;
	}

	public void setChildPricePoint(BigDecimal childPricePoint) {
		this.childPricePoint = childPricePoint;
	}

	public Integer getChildAddPrice() {
		return childAddPrice;
	}

	public void setChildAddPrice(Integer childAddPrice) {
		this.childAddPrice = childAddPrice;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {

		this.createTime = createTime;
	}
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	public Date getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(Date updateTime) {
		this.updateTime = updateTime;
	}

	public Integer getRouteType() {
		return routeType;
	}

	public void setRouteType(Integer routeType) {
		this.routeType = routeType;
	}

	public Integer getPoint() {
		return point;
	}

	public void setPoint(Integer point) {
		this.point = point;
	}

	public Integer getCostPrice() {
		return costPrice;
	}

	public void setCostPrice(Integer costPrice) {
		this.costPrice = costPrice;
	}

	public String getRuleCode() {
		return ruleCode;
	}

	public void setRuleCode(String ruleCode) {
		this.ruleCode = ruleCode;
	}

	public Integer getDeleted() {
		return deleted;
	}

	public void setDeleted(Integer deleted) {
		this.deleted = deleted;
	}

	public String getNotApplicableFlightNum() {
		return notApplicableFlightNum;
	}

	public void setNotApplicableFlightNum(String notApplicableFlightNum) {
		this.notApplicableFlightNum = notApplicableFlightNum;
	}

	public String getApplyFlightNum() {
		return applyFlightNum;
	}

	public void setApplyFlightNum(String applyFlightNum) {
		this.applyFlightNum = applyFlightNum;
	}

	public Integer getRemainCabinNum() {
		return remainCabinNum;
	}

	public void setRemainCabinNum(Integer remainCabinNum) {
		this.remainCabinNum = remainCabinNum;
	}

	public String getFlightCycle() {
		return flightCycle;
	}

	public void setFlightCycle(String flightCycle) {
		this.flightCycle = flightCycle;
	}

	public Double getFloorPrice() {
		return floorPrice;
	}

	public void setFloorPrice(Double floorPrice) {
		this.floorPrice = floorPrice;
	}

	public Double getFloorTax() {
		return floorTax;
	}

	public void setFloorTax(Double floorTax) {
		this.floorTax = floorTax;
	}

	public Integer getFitShare() {
		return fitShare;
	}

	public void setFitShare(Integer fitShare) {
		this.fitShare = fitShare;
	}

	public String getFitNationality() {
		return fitNationality;
	}

	public void setFitNationality(String fitNationality) {
		this.fitNationality = fitNationality;
	}

	public String getDisFitNationality() {
		return disFitNationality;
	}

	public void setDisFitNationality(String disFitNationality) {
		this.disFitNationality = disFitNationality;
	}

	public String getAgeRange() {
		return ageRange;
	}

	public void setAgeRange(String ageRange) {
		this.ageRange = ageRange;
	}

	public String getAttention() {
		return attention;
	}

	public void setAttention(String attention) {
		this.attention = attention;
	}

	@Override
	public String toString() {
		return "SaleRules{" +
				"id='" + id + '\'' +
				", customerId='" + customerId + '\'' +
				", channelId='" + channelId + '\'' +
				", store='" + store + '\'' +
				", ruleCode='" + ruleCode + '\'' +
				", carrier='" + carrier + '\'' +
				", org='" + org + '\'' +
				", dst='" + dst + '\'' +
				", routeType=" + routeType +
				", policyType=" + policyType +
				", policyDesc='" + policyDesc + '\'' +
				", point=" + point +
				", costPrice=" + costPrice +
				", saleSdate='" + saleSdate + '\'' +
				", saleEdate='" + saleEdate + '\'' +
				", ticketDays='" + ticketDays + '\'' +
				", tripSdate='" + tripSdate + '\'' +
				", tripEdate='" + tripEdate + '\'' +
				", status=" + status +
				", maxPrice=" + maxPrice +
				", minPrice=" + minPrice +
				", minProfit=" + minProfit +
				", adultPricePoint=" + adultPricePoint +
				", adultAddPrice=" + adultAddPrice +
				", childPricePoint=" + childPricePoint +
				", childAddPrice=" + childAddPrice +
				", operator='" + operator + '\'' +
				", createTime=" + createTime +
				", updateTime=" + updateTime +
				", deleted=" + deleted +
				", notApplicableFlightNum='" + notApplicableFlightNum + '\'' +
				", applyFlightNum='" + applyFlightNum + '\'' +
				", remainCabinNum=" + remainCabinNum +
				", cabinCode='" + cabinCode + '\'' +
				", flightCycle='" + flightCycle + '\'' +
				", floorPrice=" + floorPrice +
				", floorTax=" + floorTax +
				", fitShare=" + fitShare +
				", fitNationality='" + fitNationality + '\'' +
				", disFitNationality='" + disFitNationality + '\'' +
				", ageRange='" + ageRange + '\'' +
				", attention='" + attention + '\'' +
				'}';
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		SaleRules saleRules = (SaleRules) o;
		return Objects.equals(id, saleRules.id) &&
				Objects.equals(customerId, saleRules.customerId) &&
				Objects.equals(channelId, saleRules.channelId) &&
				Objects.equals(store, saleRules.store) &&
				Objects.equals(ruleCode, saleRules.ruleCode) &&
				Objects.equals(carrier, saleRules.carrier) &&
				Objects.equals(org, saleRules.org) &&
				Objects.equals(dst, saleRules.dst) &&
				Objects.equals(routeType, saleRules.routeType) &&
				Objects.equals(policyType, saleRules.policyType) &&
				Objects.equals(policyDesc, saleRules.policyDesc) &&
				Objects.equals(point, saleRules.point) &&
				Objects.equals(costPrice, saleRules.costPrice) &&
				Objects.equals(saleSdate, saleRules.saleSdate) &&
				Objects.equals(saleEdate, saleRules.saleEdate) &&
				Objects.equals(ticketDays, saleRules.ticketDays) &&
				Objects.equals(tripSdate, saleRules.tripSdate) &&
				Objects.equals(tripEdate, saleRules.tripEdate) &&
				Objects.equals(status, saleRules.status) &&
				Objects.equals(maxPrice, saleRules.maxPrice) &&
				Objects.equals(minPrice, saleRules.minPrice) &&
				Objects.equals(minProfit, saleRules.minProfit) &&
				Objects.equals(adultPricePoint, saleRules.adultPricePoint) &&
				Objects.equals(adultAddPrice, saleRules.adultAddPrice) &&
				Objects.equals(childPricePoint, saleRules.childPricePoint) &&
				Objects.equals(childAddPrice, saleRules.childAddPrice) &&
				Objects.equals(operator, saleRules.operator) &&
				Objects.equals(createTime, saleRules.createTime) &&
				Objects.equals(updateTime, saleRules.updateTime) &&
				Objects.equals(deleted, saleRules.deleted) &&
				Objects.equals(notApplicableFlightNum, saleRules.notApplicableFlightNum) &&
				Objects.equals(applyFlightNum, saleRules.applyFlightNum) &&
				Objects.equals(remainCabinNum, saleRules.remainCabinNum) &&
				Objects.equals(cabinCode, saleRules.cabinCode) &&
				Objects.equals(flightCycle, saleRules.flightCycle) &&
				Objects.equals(floorPrice, saleRules.floorPrice) &&
				Objects.equals(floorTax, saleRules.floorTax) &&
				Objects.equals(fitShare, saleRules.fitShare) &&
				Objects.equals(fitNationality, saleRules.fitNationality) &&
				Objects.equals(disFitNationality, saleRules.disFitNationality) &&
				Objects.equals(ageRange, saleRules.ageRange) &&
				Objects.equals(attention, saleRules.attention);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id, customerId, channelId, store, ruleCode, carrier, org, dst, routeType, policyType, policyDesc, point, costPrice, saleSdate, saleEdate, ticketDays, tripSdate, tripEdate, status, maxPrice, minPrice, minProfit, adultPricePoint, adultAddPrice, childPricePoint, childAddPrice, operator, createTime, updateTime, deleted, notApplicableFlightNum, applyFlightNum, remainCabinNum, cabinCode, flightCycle, floorPrice, floorTax, fitShare, fitNationality, disFitNationality, ageRange, attention);
	}
}
