package com.yutu.base.entity;

import java.util.Objects;

/**
 * 私有运价适用规则实体
 */
public class RuleCode {

    private String id;
    private String type;//DR 日期范围、WR 星期范围、FN 适用国籍、DN 不适用国籍、AR 年龄范围、PA 购票须知
    private String typeDesc;//类型描述 DR 日期范围、WR 星期范围、FN 适用国籍、DN 不适用国籍、AR 年龄范围、PA 购票须知
    //DR 20190410-20190510、WR 23456 17、FN CN,JP、DN CN,JP、AR 18-45、PA 购票须知123
    private String value;


    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }

    public String getTypeDesc() {
        return typeDesc;
    }
    public void setTypeDesc(String typeDesc) {
        this.typeDesc = typeDesc;
    }

    public String getValue() {
        return value;
    }
    public void setValue(String value) {
        this.value = value;
    }

    public RuleCode() {
    }

    public RuleCode(String id, String type, String typeDesc, String value) {
        this.id = id;
        this.type = type;
        this.typeDesc = typeDesc;
        this.value = value;
    }

    @Override
    public String toString() {
        return "RuleCode{" +
                "id='" + id + '\'' +
                ", type='" + type + '\'' +
                ", typeDesc='" + typeDesc + '\'' +
                ", value='" + value + '\'' +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuleCode ruleCode = (RuleCode) o;
        return Objects.equals(id, ruleCode.id) &&
                Objects.equals(type, ruleCode.type) &&
                Objects.equals(typeDesc, ruleCode.typeDesc) &&
                Objects.equals(value, ruleCode.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, type, typeDesc, value);
    }
}
