package com.yutu.base.entity;

import java.io.Serializable;

/**
 * 统一的响应实体类
 */
public class Response implements Serializable{
    private Response.Status status;
    private String errorMessage;
    private Object data;
    public Status getStatus() {
        return status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static Response success(){
        Response response=new Response();
        response.setStatus(Status.SUCCEED);
        return response;
    }
    public static Response success(Object data){
        Response response=new Response();
        response.setData(data);
        response.setStatus(Status.SUCCEED);
        return response;
    }
    public static Response error(String errorMessage){
        Response response=new Response();
        response.setStatus(Status.FAILED);
        response.setErrorMessage(errorMessage);
        return response;
    }

    public static enum Status {
        SUCCEED(200),   // 成功的状态
        FAILED(400),    // 失败的状态
        NONE,    //
        TICKET_DATE_ERROR,//航班日期错误
        FLIGHT_INFO_ERROR,//航程信息错误
        PASSENGER_INFO_ERROR,//乘客信息错误
        SERVER_INTRRNAL_ERROR;//服务内部错误

        public Integer getStatus() {
            return status;
        }

        private Integer status;

        private Status() {
        }

        private Status(Integer status) {
            this.status = status;
        }
    }

    @Override
    public String toString() {
        return "Response{" +
                "status=" + status +
                ", errorMessage='" + errorMessage + '\'' +
                ", data=" + data +
                '}';
    }
}
