package com.yutu.base.entity;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yutu.base.utils.JsonDateSerializer;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 私有运价实体类
 * @author wangycuhen
 *
 */
public class PrivateFreight implements Serializable {

	private String id;//id
	private String customerId;//客户Id
	private String carrier;//航司
	private String org;//出发
	private String dst;//抵达
	private String cabin;//舱位
	private String flightNo;//航班
	private Double floorPrice;//底价票
	private Double floorTax;//底价税
	private String ruleCodeIds;//适用规则Ids
    private String operator;//操作者
    private Date updateTime;//更新时间
    private Date createTime;//创建时间

    private List<RuleCode> ruleCodes;//规则实体List

	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}

	public String getCustomerId() {
		return customerId;
	}
	public void setCustomerId(String customerId) {
		this.customerId = customerId;
	}

	public String getCarrier() {
		return carrier;
	}
	public void setCarrier(String carrier) {
		this.carrier = carrier;
	}

	public String getOrg() {
		return org;
	}
	public void setOrg(String org) {
		this.org = org;
	}

	public String getDst() {
		return dst;
	}
	public void setDst(String dst) {
		this.dst = dst;
	}

	public String getCabin() {
		return cabin;
	}
	public void setCabin(String cabin) {
		this.cabin = cabin;
	}

	public String getFlightNo() {
		return flightNo;
	}
	public void setFlightNo(String flightNo) {
		this.flightNo = flightNo;
	}

    public Double getFloorPrice() {
        return floorPrice;
    }
    public void setFloorPrice(Double floorPrice) {
        this.floorPrice = floorPrice;
    }

    public Double getFloorTax() {
        return floorTax;
    }
    public void setFloorTax(Double floorTax) {
        this.floorTax = floorTax;
    }

    public String getRuleCodeIds() {
		return ruleCodeIds;
	}
	public void setRuleCodeIds(String ruleCodeIds) {
		this.ruleCodeIds = ruleCodeIds;
	}

    public List<RuleCode> getRuleCodes() {
        return ruleCodes;
    }
    public void setRuleCodes(List<RuleCode> ruleCodes) {
        this.ruleCodes = ruleCodes;
    }

    public String getOperator() {
        return operator;
    }
    public void setOperator(String operator) {
        this.operator = operator;
    }

    @JsonSerialize(using= JsonDateSerializer.class)
    public Date getUpdateTime() {
        return updateTime;
    }
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonSerialize(using=JsonDateSerializer.class)
    public Date getCreateTime() {
        return createTime;
    }
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public PrivateFreight() {
	}

    public PrivateFreight(String id, String customerId, String carrier, String org, String dst, String cabin, String flightNo, Double floorPrice, Double floorTax, String ruleCodeIds, String operator, Date updateTime, Date createTime, List<RuleCode> ruleCodes) {
        this.id = id;
        this.customerId = customerId;
        this.carrier = carrier;
        this.org = org;
        this.dst = dst;
        this.cabin = cabin;
        this.flightNo = flightNo;
        this.floorPrice = floorPrice;
        this.floorTax = floorTax;
        this.ruleCodeIds = ruleCodeIds;
        this.operator = operator;
        this.updateTime = updateTime;
        this.createTime = createTime;
        this.ruleCodes = ruleCodes;
    }

    @Override
    public String toString() {
        return "PrivateFreight{" +
                "id='" + id + '\'' +
                ", customerId='" + customerId + '\'' +
                ", carrier='" + carrier + '\'' +
                ", org='" + org + '\'' +
                ", dst='" + dst + '\'' +
                ", cabin='" + cabin + '\'' +
                ", flightNo='" + flightNo + '\'' +
                ", floorPrice=" + floorPrice +
                ", floorTax=" + floorTax +
                ", ruleCodeIds='" + ruleCodeIds + '\'' +
                ", operator='" + operator + '\'' +
                ", updateTime=" + updateTime +
                ", createTime=" + createTime +
                ", ruleCodes=" + ruleCodes +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PrivateFreight that = (PrivateFreight) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(customerId, that.customerId) &&
                Objects.equals(carrier, that.carrier) &&
                Objects.equals(org, that.org) &&
                Objects.equals(dst, that.dst) &&
                Objects.equals(cabin, that.cabin) &&
                Objects.equals(flightNo, that.flightNo) &&
                Objects.equals(floorPrice, that.floorPrice) &&
                Objects.equals(floorTax, that.floorTax) &&
                Objects.equals(ruleCodeIds, that.ruleCodeIds) &&
                Objects.equals(operator, that.operator) &&
                Objects.equals(updateTime, that.updateTime) &&
                Objects.equals(createTime, that.createTime) &&
                Objects.equals(ruleCodes, that.ruleCodes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, customerId, carrier, org, dst, cabin, flightNo, floorPrice, floorTax, ruleCodeIds, operator, updateTime, createTime, ruleCodes);
    }
}
