package com.yutu.base.entity;

import java.io.Serializable;

public class NoteResult<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 状态码 0-成功  2-失败
     */
    private int status;
    /**
     * 消息提示,如(成功)
     */
    private String msg;
    /**
     * 额外信息
     */
    private String info;
    /**
     * 设置要返回的具体数据
     */
    private T data;//返回的数据

    public NoteResult() {

    }

    public NoteResult(int status, String msg, T data) {
        this.status = status;
        this.msg = msg;
        this.data = data;
    }

    public Object getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    /**
     * 状态值 枚举
     */
    public static enum Status {
        SUCCEED(200, "SUCCESS"),   // 成功的状态
        FAILED(400, "FAILED"),    // 失败的状态
        ERROR(300, "ERROR"),      // 出错的状态
        NONE,    //
        TICKET_DATE_ERROR,//航班日期错误
        FLIGHT_INFO_ERROR,//航程信息错误
        PASSENGER_INFO_ERROR,//乘客信息错误
        SERVER_INTRRNAL_ERROR;//服务内部错误

        private Integer status;
        private String msg;

        private Status() {
        }

        private Status(Integer status){
            this.status = status;
        }
        private Status(Integer status, String msg) {
            this.status = status;
            this.msg = msg;
        }

        public Integer getStatus() {
            return status;
        }

        public String getMsg(){
            return msg;
        }
    }

    public static NoteResult success(){
        NoteResult noteResult = new NoteResult();
        noteResult.setStatus(Status.SUCCEED.getStatus());
        noteResult.setMsg(Status.SUCCEED.getMsg());
        noteResult.setData(new Object());
        return noteResult;
    }

    public static NoteResult success(Object data){
        NoteResult noteResult = new NoteResult();
        noteResult.setStatus(Status.SUCCEED.getStatus());
        noteResult.setMsg(Status.SUCCEED.getMsg());
        noteResult.setData(data);
        return noteResult;
    }

    public static NoteResult error(String errorMessage){
        NoteResult noteResult = new NoteResult();
        noteResult.setStatus(Status.ERROR.getStatus());
        noteResult.setMsg(errorMessage);
        noteResult.setData(new Object());
        return noteResult;
    }

    @Override
    public String toString() {
        return "NoteResult [status=" + status + ", msg=" + msg + ", info="
                + info + ", data=" + data + "]";
    }

}
