package com.yutu.base.controller;

import com.yutu.base.entity.Response;
import com.yutu.base.service.UploadService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping("statementApi/")
public class UploadController {
    Logger logger = Logger.getLogger("upload");
    @Autowired
    private UploadService uploadService;

    @RequestMapping(value = "upload/saleRules",method = RequestMethod.POST)
    public Response uploadSaleRules(@RequestBody String requestBody){
        logger.info("上传销售规则,参数:"+requestBody);
        Response response =  uploadService.uploadSaleRules(requestBody);
        logger.info("上传结果："+response);
        return response;
    }

    @RequestMapping(value = "privateFreight/upload",method = RequestMethod.POST)
    public Response uploadPrivateFreight(@RequestBody String requestBody){
        logger.info("上传私有运价底价配置,参数:"+requestBody);
        Response response =  uploadService.uploadPrivateFreight(requestBody);
        logger.info("上传结果："+response);
        return response;
    }

}
