package com.yutu.base.controller;


import com.yutu.base.service.SaleDetailService;
import com.yutu.base.service.SalesSummaryService;
import com.yutu.comm.response.NoteResult;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * 报表管理：
 *      销售明细报表
 *      销售汇总报表
 * 20210319111255
 */
@RestController
@RequestMapping("statementApi/")
public class StatementController {

    private Logger logger = Logger.getLogger("download");
    @Autowired
    private SaleDetailService saleDetailService;
    @Autowired
    private SalesSummaryService salesSummaryService;

    /**
     * 销售明细报表页面 获取销售明细数据
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "salesDetail/getSalesDetailList", method = RequestMethod.POST)
    public NoteResult getSalesDetailList(@RequestBody String requestBody){
        return saleDetailService.getSalesDetailList(requestBody);
    }

    /**
     * 下载销售报表(符合查询条件时，直接从数据库SaleDetail表中直接下载获取报表数据)
     * 销售明细报表 导出报表（新）
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "salesDetail/downloadSalesDetailReport", method = RequestMethod.POST)
    public NoteResult saleDetailReportFromAutoSource(@RequestBody String requestBody, HttpServletResponse response){
        NoteResult noteResult = saleDetailService.downloadSalesDetailReportExcel(requestBody, response);
        if (noteResult.getStatus() != 200 ){
            response.setStatus(204);
        }
        return saleDetailService.downloadSalesDetailReportExcel(requestBody, response);
    }

    /**
     * 查询销售汇总数据   salesSummary
     *
     * @date 20210325135607
     * @param requestBody
     * @return
     */
//    @GetMapping(value = "salesSummary/getSalesSummaryList")
    @RequestMapping(value = "salesSummary/getSalesSummaryList", method = RequestMethod.POST)
    public NoteResult getSalesSummaryList(@RequestBody String requestBody){
        return salesSummaryService.getSalesSummaryList(requestBody);
    }



















}
