package com.yutu.base.controller;

import com.yutu.base.entity.Response;
import com.yutu.base.service.DownLoadService;
import com.yutu.base.service.OrderService;
import com.yutu.base.service.PrivateFreightService;
import com.yutu.base.service.SaleDetailService;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("statementApi/")
public class DownLoadController {

    private Logger logger = Logger.getLogger("download");
    @Autowired
    private DownLoadService downLoadService;
    @Autowired
    private SaleDetailService saleDetailService;
    @Autowired
    private OrderService orderService;
    @Autowired
    private PrivateFreightService privateFreightService;

















    /**
     * 获取销售数据
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "download/getSaleDetailData",method = RequestMethod.POST)
    public Response getSaleDetail(@RequestBody String requestBody){
        return downLoadService.getSaleDetailReportData(requestBody);
    }
    /**
     * 下载销售报表
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "download/saleDetailReport",method = RequestMethod.POST)
    public Response saleDetailReport(@RequestBody String requestBody){
        return downLoadService.downLoadSaleDetailReport(requestBody);
    }
    /**
     * 下载销售报表(符合查询条件时，直接从数据库SaleDetail表中直接下载获取报表数据)
     * 快速导出报表（新）
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "download/saleDetailReportFromAutoSource",method = RequestMethod.POST)
    public Response saleDetailReportFromAutoSource(@RequestBody String requestBody){
        return downLoadService.downLoadSaleDetailFromAutoSource(requestBody);
    }
    /**
     * 传入报表数据，解析为saleDetail表数据对象List
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "parse/toSaleDetail",method = RequestMethod.POST)
    public Response parseToSaleDetail(@RequestBody String requestBody){
        System.out.println("---------------");
        return downLoadService.parseToSaleDetail(requestBody);
    }
    /**
     * 下载加价规则
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "download/saleRules",method = RequestMethod.POST)
    public Response downLoadSaleRules(@RequestBody String requestBody){
        logger.info("下载加价规则,参数:"+requestBody);
        return downLoadService.downLoadSaleRules(requestBody);
    }

    /**
     * 队列更新报表数据
     * @param requestBody
     * @return
     */
    @RequestMapping(value = "saleDetail/updateSaleDetail",method = RequestMethod.POST)
    public Response updateSaleDetail(@RequestBody String requestBody){
        return saleDetailService.updateSaleDetail(requestBody);
    }

    /**
     * 按照生单日期导出订单信息
     */
    @RequestMapping(value = "order/exportOrderInfo",method = RequestMethod.POST)
    public Response exportOrderInfo(@RequestBody String requestBody){
        return orderService.exportOrderInfo(requestBody);
    }
    /**
     * 按照指定条件导出私有运价底价配置
     */
    @RequestMapping(value = "privateFreight/download",method = RequestMethod.POST)
    public Response exportPrivateFreight(@RequestBody String requestBody){
        return privateFreightService.exportPrivateFreight(requestBody);
    }





}
